/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.ArrayList;
import java.util.List;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.requests.FriendRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Relation;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import lombok.Getter;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class ChatUserListWidget extends C_1630332 {

	private final List<UserListEntry> entries = new ArrayList<>();
	private final ChatScreen screen;
	private int selectedEntry = -1;

	public ChatUserListWidget(ChatScreen screen, C_8105098 client, int width, int height, int top, int bottom, int entryHeight) {
		super(client, width, height, top, bottom, entryHeight);
		this.screen = screen;
	}

	public void setUsers(List<User> users, Channel channel) {
		users.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).forEach(user -> addEntry(new UserListEntry(user, channel)));
	}

	@Override
	protected int m_3021017() {
		return this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2 + f_2695432 - 8;
	}

	@Override
	protected int m_3791031() {
		return entries.size();
	}

	@Override
	public int m_6519286() {
		return f_2695432 - 5;
	}

	public void addEntry(UserListEntry entry) {
		entries.add(entry.init(screen));
	}

	@Override
	public C_8277969 m_7118949(int i) {
		return entries.get(i);
	}

	@Override
	protected boolean m_5993229(int i) {
		return i == selectedEntry;
	}

	@Override
	protected void m_6989976(int i, int j) {
		super.m_6989976(i, j);
		C_3754158.m_7547086();
		f_3511485.m_1218956().m_5325521(C_2691939.f_9745145);

	}

	public class UserListEntry extends C_2691939 implements C_1630332.C_8277969 {

		@Getter
		private final User user;
		private final C_8105098 client;
		private final Channel channel;
		private long time;
		private ChatScreen screen;

		public UserListEntry(User user, Channel channel) {
			this.client = C_8105098.m_0408063();
			this.user = user;
			this.channel = channel;
		}

		public UserListEntry init(ChatScreen screen) {
			this.screen = screen;
			return this;
		}

		@Override
		public void m_1433237(int i, int j, int k) {

		}

		@Override
		public void m_2013749(int index, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered) {
			if (hovered) {
				m_7865719(x - 2, y - 1, x + entryWidth - 3, y + entryHeight + 1, 0x55ffffff);
			}
			DrawUtil.drawScrollableText(client.f_0426313, user.getName(), x + 3 + entryHeight, y + 1, x + entryWidth - 6, y + 1 + client.f_0426313.f_6725889 + 2, -1);
			DrawUtil.drawScrollableText(client.f_0426313, user.getStatus().getTitle(), x + 3 + entryHeight,
				y + 12, x + entryWidth - 6, y + 12 + client.f_0426313.f_6725889 + 2, 8421504);

			client.m_1218956().m_5325521(Auth.getInstance().getSkinTexture(user.getUuid(), user.getName()));
			C_3754158.m_9671730();
			C_3754158.m_6326777(1, 1, 1);
			m_4673442(x, y, 8, 8, 8, 8, entryHeight, entryHeight, 64, 64);
			m_4673442(x, y, 40, 8, 8, 8, entryHeight, entryHeight, 64, 64);
			C_3754158.m_5313301();
		}

		@Override
		public boolean m_3739705(int index, int mouseX, int mouseY, int button, int x, int y) {
			ChatUserListWidget.this.selectedEntry = index;
			if (button == 0) { // left click
				if (C_8105098.m_6224581() - this.time < 250L && client.f_4601986 == null) { // left *double* click

				}
				this.time = C_8105098.m_6224581();
			} else if (button == 1) { // right click

				if (!user.equals(API.getInstance().getSelf())) {
					ContextMenu.Builder menu = ContextMenu.builder().title(user.getName())
						.spacer();
					if (!channel.isDM()) {
						menu.entry("api.friends.chat", buttonWidget -> {
							ChannelRequest.getOrCreateDM(user)
								.whenCompleteAsync((channel, throwable) -> client.m_2167033(() -> client.m_6408915(new ChatScreen(screen.getParent(), channel))));
						}).spacer();
					}
					if (user.getRelation() != Relation.BLOCKED) {
						if (user.getRelation() != Relation.FRIEND) {
							menu.entry("api.friends.add", b -> FriendRequest.getInstance().addFriend(user.getUuid())).spacer();
						}
						menu.entry("api.users.block", buttonWidget ->
							FriendRequest.getInstance().blockUser(user));
					} else {
						menu.entry("api.users.unblock", buttonWidget ->
							FriendRequest.getInstance().unblockUser(user));
					}
					if (channel.getOwner().equals(API.getInstance().getSelf())) {
						menu.spacer().entry("api.channel.remove_user", b -> ChannelRequest.removeUserFromChannel(channel, user));
					}
					screen.setContextMenu(menu.build());
					return true;
				}
			}

			return false;
		}

		@Override
		public void m_4703785(int i, int j, int k, int l, int m, int n) {

		}
	}
}
