/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.multiplayer;

import java.util.Collections;
import java.util.List;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.handlers.StatusUpdateHandler;
import io.github.axolotlclient.api.requests.FriendRequest;
import lombok.Getter;
import net.minecraft.unmapped.C_1533205;
import net.minecraft.unmapped.C_2160183;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3268052;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3404273;
import net.minecraft.unmapped.C_4505797;
import net.minecraft.unmapped.C_7056743;
import org.lwjgl.input.Keyboard;

public class FriendsMultiplayerScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen implements C_3268052 {
	@Getter
	private final C_3404273 pinger = new C_3404273();
	private final C_3020744 lastScreen;
	protected FriendsMultiplayerSelectionList serverSelectionList;
	private ButtonWidget selectButton;
	private C_1533205 editingServer;
	private boolean initialized;
	private List<String> tooltipText;
	private final ButtonWidget friendsCountButton = new VanillaButtonWidget(0, 0, 150, 20, C_3390001.m_2053009("api.servers.friends", "..."), button -> {
	});
	private boolean directConnectDialog = false;
	private static final String NO_ONLINE_FRIENDS = C_3390001.m_2053009("api.servers.friends.no_online_friends");

	public FriendsMultiplayerScreen(C_3020744 lastScreen) {
		super(C_3390001.m_2053009("api.servers.friends.title"));
		this.lastScreen = lastScreen;
	}

	@Override
	public void m_3593494() {
		super.m_3593494();
		Keyboard.enableRepeatEvents(true);
		if (this.initialized) {
			this.serverSelectionList.updateSize(this.f_5465691, this.f_3080061, 60, this.f_3080061 - 64);
		} else {
			this.serverSelectionList = new FriendsMultiplayerSelectionList(this, this.f_7153641, this.f_5465691, this.f_3080061 - 64 - 60, 60, 36);
		}
		StatusUpdateHandler.addUpdateListener("friends_multiplayer_screen", serverSelectionList::updateEntry);
		this.addDrawableChild(this.serverSelectionList);
		addDrawableChild(new VanillaButtonWidget(this.f_5465691 / 2 - 102, 32, 100, 20, C_3390001.m_2053009("api.servers"), button ->
			f_7153641.m_6408915(new C_2160183(lastScreen))));
		addDrawableChild(friendsCountButton);
		friendsCountButton.setX(f_5465691 / 2 + 2);
		friendsCountButton.setY(32);
		friendsCountButton.setWidth(100);
		friendsCountButton.active = false;

		if (!initialized) {
			initialized = true;
			FriendRequest.getInstance().getFriends().thenAccept(friends -> {
				friendsCountButton.setMessage(C_3390001.m_2053009("api.servers.friends", friends.stream().filter(u -> u.getStatus().isOnline()).count()));
				this.serverSelectionList.updateList(friends);
			});
		}

		this.selectButton = this.addDrawableChild(
			new VanillaButtonWidget(f_5465691 / 2 - 154, f_3080061 - 64 + 12, 100, 20,
				C_3390001.m_2053009("selectServer.select"), buttonx -> this.joinSelectedServer()));
		this.addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 50, f_3080061 - 64 + 12, 100, 20,
			C_3390001.m_2053009("selectServer.direct"), buttonx -> {
			directConnectDialog = true;
			this.editingServer = new C_1533205(C_3390001.m_2053009("selectServer.defaultName"), "", false);
			this.f_7153641.m_6408915(new C_7056743(this, this.editingServer));
		}));
		this.addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 + 50 + 4, f_3080061 - 64 + 12, 100, 20,
			C_3390001.m_2053009("api.friends"), buttonx ->
			this.f_7153641.m_6408915(new FriendsScreen(this))));
		ButtonWidget editButton = this.addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 154, f_3080061 - 64 + 12 + 20 + 4, 74, 20,
			C_3390001.m_2053009("selectServer.edit"), buttonx -> {
		}));
		editButton.active = false;
		ButtonWidget deleteButton = this.addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 76, f_3080061 - 64 + 12 + 20 + 4, 74, 20,
			C_3390001.m_2053009("selectServer.delete"), buttonx -> {
		}));
		deleteButton.active = false;
		this.addDrawableChild(
			new VanillaButtonWidget(f_5465691 / 2 + 2, f_3080061 - 64 + 12 + 20 + 4, 74, 20,
				C_3390001.m_2053009("selectServer.refresh"), buttonx -> this.refreshServerList()));
		this.addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 + 80, f_3080061 - 64 + 12 + 20 + 4, 74, 20,
			C_3390001.m_2053009("gui.back"), buttonx -> this.f_7153641.m_6408915(this.lastScreen)));

		this.onSelectedChange();
	}

	@Override
	public void m_2450377() {
		super.m_2450377();
		this.pinger.m_8251131();
	}

	@Override
	public void m_8984281() {
		Keyboard.enableRepeatEvents(false);
		this.pinger.m_3188619();
		StatusUpdateHandler.removeUpdateListener("friends_multiplayer_screen");
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float partialTick) {
		this.tooltipText = null;
		super.m_7261014(mouseX, mouseY, partialTick);
		m_2717572(f_2020658, getTitle(), f_5465691 / 2, 15, -1);

		if (serverSelectionList.children().isEmpty()) {
			m_2717572(f_2020658, NO_ONLINE_FRIENDS, f_5465691 / 2, f_3080061 / 2 - f_2020658.f_6725889 / 2, -1);
		}
		if (this.tooltipText != null) {
			this.m_9128141(this.tooltipText, mouseX, mouseY);
		}
	}

	private void refreshServerList() {
		this.f_7153641.m_6408915(new FriendsMultiplayerScreen(this.lastScreen));
	}

	private void directJoinCallback(boolean confirmed) {
		if (confirmed) {
			this.join(this.editingServer);
		} else {
			this.f_7153641.m_6408915(this);
		}
	}

	public void joinSelectedServer() {
		FriendsMultiplayerSelectionList.Entry entry = this.serverSelectionList.getSelectedOrNull();
		this.join(entry.getServerData());
	}

	private void join(C_1533205 server) {
		if (server == null) {
			return;
		}
		this.f_7153641.m_6408915(new C_4505797(this, this.f_7153641, server));
	}

	public void setSelected(FriendsMultiplayerSelectionList.Entry selected) {
		this.serverSelectionList.setSelected(selected);
		this.onSelectedChange();
	}

	protected void onSelectedChange() {
		this.selectButton.active = false;
		FriendsMultiplayerSelectionList.Entry entry = this.serverSelectionList.getSelectedOrNull();
		if (entry != null && !(entry instanceof FriendsMultiplayerSelectionList.LoadingHeader)) {
			this.selectButton.active = entry.canJoin();
		}
	}

	public void setDeferredTooltip(List<String> text) {
		this.tooltipText = text;
	}

	public void setDeferredTooltip(String text) {
		if (text != null && !text.isEmpty()) {
			this.tooltipText = Collections.singletonList(text);
		}
	}

	@Override
	public void m_7743236(boolean bl, int i) {
		if (this.directConnectDialog) {
			this.directConnectDialog = false;
			directJoinCallback(bl);
		}
	}
}
