/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.multiplayer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.unmapped.C_1533205;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_8607758;
import com.mojang.authlib.GameProfile;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.util.UUIDHelper;
import org.apache.commons.lang3.StringUtils;

public class ServerInfoUtil {
	public static Status.Activity.ServerInfo getServerInfo(String levelName, C_8607758 status) {
		if (status == null) {
			return new Status.Activity.ServerInfo(levelName, null, null, null, null);
		}
		return new Status.Activity.ServerInfo(levelName, status.m_2848944().m_6222303(),
			Optional.ofNullable(status.m_6436922()).map(Status.Activity.ServerInfo.Favicon::fromString).orElse(null),
			Optional.ofNullable(status.m_8621988()).map(p ->
				new Status.Activity.ServerInfo.Players(p.m_1535871(), p.m_1362915(),
					Arrays.stream(p.m_5317475()).map(prof -> new Status.Activity.ServerInfo.Players.Player(prof.getName(), UUIDHelper.toUndashed(prof.getId()))).toList())
			).orElse(null),
			Optional.ofNullable(status.m_4733291()).map(v -> new Status.Activity.ServerInfo.Version(v.m_4436360(), v.m_0123600())).orElse(null));
	}

	public static C_8607758 getServerStatus(Status.Activity.ServerInfo info) {
		var metadata = new C_8607758();
		metadata.m_5089747(new C_1716360(info.levelName()));
		Optional.ofNullable(info.players()).map(p -> {
			var players = new C_8607758.C_9521081(p.max(),
				p.online());
			players.m_5986708(p.sample().stream().map(prof -> new GameProfile(UUIDHelper.fromUndashed(prof.uuid()), prof.name())).toArray(GameProfile[]::new));
			return players;
		}).ifPresent(metadata::m_1196569);
		Optional.ofNullable(info.icon()).map(Status.Activity.ServerInfo.Favicon::toString).ifPresent(metadata::m_6471821);
		Optional.ofNullable(info.version()).map(v -> new C_8607758.C_7040679(v.name(), v.protocol())).ifPresent(metadata::m_5192782);
		return metadata;
	}

	public static C_1533205 getServerData(String username, Status.Activity.E4mcMetadata metadata) {
		C_8607758 serverMetadata = metadata.serverInfo() != null ? getServerStatus(metadata.serverInfo()) : null;
		var data = new C_1533205(username, metadata.domain(), false);
		if (serverMetadata != null) {
			if (serverMetadata.m_6436922().startsWith("data:image/png;base64,")) {
				data.m_1622917(serverMetadata.m_6436922().substring("data:image/png;base64,".length()));
			} else {
				data.m_1622917(null);
			}
			data.f_2449978 = metadata.serverInfo().levelName();
			Optional.ofNullable(serverMetadata.m_4733291()).ifPresentOrElse(ver -> {
				data.f_3146804 = ver.m_4436360();
				data.f_9567457 = ver.m_0123600();
			}, () -> {
				data.f_3146804 = C_3390001.m_2053009("multiplayer.status.old");
				data.f_9567457 = 0;
			});
			Optional.ofNullable(serverMetadata.m_8621988()).ifPresentOrElse(player -> {
				data.f_2418160 = C_1945050.f_7540461
					+ ""
					+ player.m_1362915()
					+ C_1945050.f_2985643
					+ "/"
					+ C_1945050.f_7540461
					+ player.m_1535871();
				if (player.m_5317475().length > 0) {
					List<String> list = new ArrayList<>(player.m_5317475().length);

					for (GameProfile gameProfile : player.m_5317475()) {
						list.add(gameProfile.getName());
					}

					if (player.m_5317475().length < player.m_1362915()) {
						list.add(C_3390001.m_2053009("multiplayer.status.and_more", player.m_1362915() - player.m_5317475().length));
					}

					data.f_2418160 = StringUtils.join(list, "\n");
				} else {
					data.f_2418160 = "";
				}
			}, () -> data.f_2449978 = C_3390001.m_2053009("multiplayer.status.unknown").formatted(C_1945050.f_2985643));
		}
		return data;
	}
}
