/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.impl;

import io.github.axolotlclient.bridge.item.AxoItemStack;
import io.github.axolotlclient.bridge.render.AxoFont;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.bridge.render.AxoSprite;
import io.github.axolotlclient.bridge.util.AxoText;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.ItemUtil;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9550253;
import org.jetbrains.annotations.Nullable;

public class AxoRenderContextImpl implements AxoRenderContext {
	@Nullable
	private static AxoRenderContextImpl INSTANCE;

	public static AxoRenderContext getInstance() {
		if (INSTANCE == null) {
			INSTANCE = new AxoRenderContextImpl();
		}

		return INSTANCE;
	}

	private final C_8105098 client = C_8105098.m_0408063();

	@Override
	public void br$popMatrix() {
		C_3754158.m_2041265();
	}

	@Override
	public void br$pushMatrix() {
		C_3754158.m_8373640();
	}

	@Override
	public void br$scaleMatrix(float sx, float sy, float sz) {
		C_3754158.m_4552250(sx, sy, sz);
	}

	@Override
	public void br$translateMatrix(float x, float y, float z) {
		C_3754158.m_3172490(x, y, z);
	}

	@Override
	public void br$pushScissor(int x, int y, int w, int h) {
		io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil.pushScissor(x, y, w, h);
	}

	@Override
	public void br$popScissor() {
		io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil.popScissor();
	}

	@Override
	public void br$glEnableBlend() {
		C_3754158.m_9671730();
	}

	@Override
	public void br$glEnableAlpha() {
		C_3754158.m_2754767();
	}

	@Override
	public void br$glDisableBlend() {
		C_3754158.m_5313301();
	}

	@Override
	public void br$glDisableAlpha() {
		C_3754158.m_6191982();
	}

	@Override
	public void br$glColor4(float r, float g, float b, float a) {
		C_3754158.m_3323122(r, g, b, a);
	}

	@Override
	public void br$fillRect(int x, int y, int width, int height, int color) {
		DrawUtil.fillRect(x, y, width, height, color);
	}

	@Override
	public void br$outlineRect(int x, int y, int width, int height, int color) {
		DrawUtil.outlineRect(x, y, width, height, color);
	}

	@Override
	public void br$drawTexture(int x, int y, int width, int height, AxoSprite sprite) {
		((AxoSpriteImpl) sprite).draw(client, x, y, width, height);
	}

	@Override
	public int br$drawString(String value, int x, int y, int color, boolean shadow) {
		return client.f_0426313.m_4413321(value, x, y, color, shadow);
	}

	@Override
	public int br$drawString(AxoText value, int x, int y, int color, boolean shadow) {
		return br$drawString(((C_9550253) value).m_2117196(), x, y, color, shadow);
	}

	@Override
	public void br$drawCenteredString(String value, int x, int y, int color, boolean shadow) {
		AxoRenderContext.super.br$drawCenteredString(value, x, y, color, shadow);
	}

	@Override
	public AxoFont br$getFont() {
		return client.f_0426313;
	}

	@Override
	public void br$renderGuiItemModel(AxoItemStack stack, int x, int y) {
		final var vanilla = Bridge.unwrapStack(stack);

		if (vanilla != null) {
			ItemUtil.renderGuiItemModel(vanilla, x, y);
		}
	}

	@Override
	public void br$renderGuiItemOverlay(AxoItemStack stack, int x, int y, String countLabel, int textColor, boolean shadow) {
		ItemUtil.renderGuiItemOverlay(
			client.f_0426313,
			Bridge.unwrapStack(stack), x, y, countLabel, textColor,
			shadow
		);
	}
}
