/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.impl;

import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.bridge.render.AxoSprite;
import io.github.axolotlclient.util.Util;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public interface AxoSpriteImpl extends AxoSprite {
	void draw(C_8105098 client, int sX, int sY, int sW, int sH);

	record Simple(C_0561170 id, int x, int y, int width, int height) implements AxoSpriteImpl {
		@Override
		public void draw(C_8105098 client, int sX, int sY, int sW, int sH) {
			C_3754158.m_6326777(1, 1, 1);
			client.m_1218956().m_5325521(id);
			C_2691939.m_5935491(sX, sY, x, y, sW, sH, width, height);
		}
	}

	record Config(GraphicsOption option) implements AxoSpriteImpl {
		@Override
		public void draw(C_8105098 client, int sX, int sY, int sW, int sH) {
			C_3754158.m_6326777(1, 1, 1);
			Util.bindTexture(option);
			C_2691939.m_5935491(sX, sY, 0, 0, sW, sH, option.get().getWidth(), option.get().getHeight());
		}
	}
}
