/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.google.common.base.Preconditions;
import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.impl.commands.CommandsImpl;
import io.github.axolotlclient.bridge.item.AxoItemStack;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_3628668;
import net.minecraft.unmapped.C_3755722;
import net.minecraft.unmapped.C_7778778;
import net.ornithemc.osl.keybinds.api.KeyBindingEvents;
import net.ornithemc.osl.lifecycle.api.client.MinecraftClientEvents;
import net.ornithemc.osl.networking.api.client.ClientConnectionEvents;
import net.ornithemc.osl.resource.loader.api.ResourceLoaderEvents;
import org.jetbrains.annotations.Nullable;

public class Bridge {
	@Nullable
	private static List<C_7778778> keyBindings = new ArrayList<>();

	public static AxoItemStack wrapStack(@Nullable C_2454309 stack) {
		// TODO: this is a bit of a janky workaround, but whatever...
		return Objects.requireNonNullElseGet(stack, () -> new C_2454309(C_3755722.m_0135857(C_3628668.f_1888477), 0));
	}

	@Nullable
	public static C_2454309 unwrapStack(AxoItemStack stack) {
		if (stack.br$isEmpty()) {
			return null;
		}

		Preconditions.checkArgument(stack instanceof C_2454309, "stack instanceof ItemStack");
		return (C_2454309) stack;
	}

	public static void addKeybind(C_7778778 keyBinding) {
		Preconditions.checkState(keyBindings != null, "keybind registered too late!");
		keyBindings.add(keyBinding);
	}

	public static void init() {
		KeyBindingEvents.REGISTER_KEYBINDS.register(keyBindingRegistry -> {
			Preconditions.checkState(keyBindings != null, "double keybind register");
			keyBindings.forEach(keyBindingRegistry::register);
			keyBindings = null;
		});

		MinecraftClientEvents.START.register(minecraft -> Events.CLIENT_START.invoker().run());
		MinecraftClientEvents.READY.register(minecraft -> Events.CLIENT_READY.invoker().run());
		MinecraftClientEvents.STOP.register(minecraft -> Events.CLIENT_STOP.invoker().run());
		MinecraftClientEvents.TICK_END.register(minecraft -> Events.TICK.invoker().run());
		ResourceLoaderEvents.END_RESOURCE_RELOAD.register(() -> Events.END_RESOURCE_RELOAD.invoker().run());
		ClientConnectionEvents.PLAY_READY.register(mc -> Events.CONNECTION_PLAY_READY.invoker().run());
		ClientConnectionEvents.DISCONNECT.register(mc -> Events.DISCONNECT.invoker().run());
	}

	public static void postInit() {
		Events.COMMAND_REGISTER.invoker().accept(CommandsImpl.getInstance());
	}
}
