/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.unmapped.C_1023567;
import net.minecraft.unmapped.C_1331819;
import net.minecraft.unmapped.C_1533205;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_6577431;
import net.minecraft.unmapped.C_7873567;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8651652;
import net.minecraft.unmapped.C_8730536;
import net.minecraft.unmapped.C_9550253;
import com.google.common.util.concurrent.ListenableFuture;
import io.github.axolotlclient.bridge.AxoMinecraftClient;
import io.github.axolotlclient.bridge.AxoPlayerListEntry;
import io.github.axolotlclient.bridge.AxoSession;
import io.github.axolotlclient.bridge.entity.AxoPlayer;
import io.github.axolotlclient.bridge.key.AxoClientKeybinds;
import io.github.axolotlclient.bridge.render.AxoFont;
import io.github.axolotlclient.bridge.resource.AxoResourceManager;
import io.github.axolotlclient.bridge.util.AxoText;
import io.github.axolotlclient.bridge.world.AxoWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(C_8105098.class)
public abstract class MinecraftClientMixin implements AxoMinecraftClient {
	@Shadow
	public C_3831727 textRenderer;

	@Shadow
	public C_1023567 player;

	@Shadow
	public C_7873567 world;

	@Shadow
	public C_1331819 options;

	@Shadow
	@Final
	private C_8730536 session;

	@Shadow
	public abstract boolean isInSingleplayer();

	@Shadow
	public abstract C_1533205 getCurrentServerEntry();

	@Shadow
	public C_8651652 gui;

	@Shadow
	public C_3020744 screen;

	@Shadow
	public abstract C_6577431 getResourceManager();

	@Shadow
	public abstract ListenableFuture<Object> submit(Runnable runnable);

	@Override
	public @Nullable AxoPlayer br$getPlayer() {
		return player;
	}

	@Override
	public AxoWorld br$getWorld() {
		return world;
	}

	@Override
	public AxoFont br$getFont() {
		return textRenderer;
	}

	@Override

	public AxoClientKeybinds br$getKeybinds() {
		return options;
	}

	@Override
	public AxoSession br$getSession() {
		return new AxoSession(session.m_4631150(), session.m_2698451(), session.m_1063667());
	}

	@Override
	public boolean br$isLocalServer() {
		return isInSingleplayer();
	}

	@Override
	public String br$getServerAddress() {
		return Optional.ofNullable(getCurrentServerEntry()).map(x -> x.f_7619058).orElse(null);
	}

	@Override
	public Collection<? extends AxoPlayerListEntry> br$getOnlinePlayers() {
		return player == null ? List.of()
			: Collections.unmodifiableCollection(player.f_6362094.m_9082306());
	}

	@Override
	public void br$sendToClient(AxoText msg) {
		gui.m_8449802().m_7344462((C_9550253) msg);
	}

	@Override
	public void br$sendToServer(String msg) {
		player.m_2226526(msg);
	}

	@Override
	public void br$reinitScreen() {
		if (screen != null) {
			screen.m_0116202((C_8105098) (Object) this, screen.f_5465691, screen.f_3080061);
		}
	}

	@Override
	public AxoResourceManager br$getResourceManager() {
		return getResourceManager();
	}

	@Override
	public void execute(@NotNull Runnable command) {
		this.submit(command);
	}

	@Override
	public Object br$getScreen() {
		return screen;
	}
}
