/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.entity;

import java.util.UUID;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_0557736;
import io.github.axolotlclient.bridge.entity.AxoEntity;
import io.github.axolotlclient.bridge.math.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(C_0539808.class)
public abstract class EntityMixin implements AxoEntity {
	@Shadow
	@Nullable
	public C_0539808 vehicle;

	@Shadow
	public double z;

	@Shadow
	public double y;

	@Shadow
	public double x;

	@Shadow
	public double velocityX;

	@Shadow
	public double velocityY;

	@Shadow
	public double velocityZ;

	@Shadow
	public boolean onGround;

	@Shadow
	public abstract C_0557736 getRotationVec(float tickDelta);

	@Shadow
	public float yaw;

	@Shadow
	public abstract UUID getUuid();

	@Shadow
	public float pitch;

	@Shadow
	private int networkId;

	@Override
	public @Nullable AxoEntity br$getVehicle() {
		return vehicle;
	}

	@Override
	public Vec3 br$getPos() {
		return new Vec3(this.x, this.y, this.z);
	}

	@Override
	public Vec3 br$getVelocity() {
		return new Vec3(this.velocityX, this.velocityY, this.velocityZ);
	}

	@Override
	public boolean br$isOnGround() {
		return onGround;
	}

	@Override
	public float br$getYaw() {
		return yaw;
	}

	@Override
	public float br$getPitch() {
		return pitch;
	}

	@Override
	public Vec3 br$getRotation(float deltaTick) {
		final var vec = getRotationVec(deltaTick);
		return new Vec3(vec.f_8797516, vec.f_7064947, vec.f_1767139);
	}

	@Override
	public UUID br$getUuid() {
		return getUuid();
	}

	@Override
	public int br$getNetId() {
		return networkId;
	}
}
