/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.item;

import com.google.common.base.Preconditions;
import io.github.axolotlclient.bridge.item.AxoEnchant;
import io.github.axolotlclient.bridge.item.AxoItem;
import io.github.axolotlclient.bridge.item.AxoItemStack;
import io.github.axolotlclient.bridge.item.AxoItems;
import io.github.axolotlclient.bridge.util.AxoText;
import net.minecraft.unmapped.C_0230498;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_3755722;
import net.minecraft.unmapped.C_5693434;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(C_2454309.class)
public abstract class ItemStackMixin implements AxoItemStack {
	@Shadow
	public abstract C_3755722 getItem();

	@Shadow
	public int size;

	@Shadow
	public abstract C_2454309 copy();

	@Shadow
	public abstract void setItem(C_3755722 par1);

	@Shadow
	public abstract int getDamage();

	@Shadow
	public abstract int getMaxDamage();

	@Shadow
	public abstract C_5693434 getEnchantments();

	@Shadow
	public abstract void addEnchantment(C_0230498 enchantment, int level);

	@Shadow
	public abstract String getHoverName();

	@Override
	public AxoItem br$getItem() {
		if (size == 0) {
			return AxoItems.AIR;
		}

		return getItem();
	}

	@Override
	public AxoItemStack br$copy() {
		return copy();
	}

	@Override
	public void br$setCount(int count) {
		size = count;
	}

	@Override
	public int br$getCount() {
		return size;
	}

	@Override
	public int br$getDamage() {
		return getDamage();
	}


	@Override
	public int br$getMaxDamage() {
		return getMaxDamage();
	}

	@Unique
	@Nullable
	private C_2018497 axolotlclient$getEnchantment(int id) {
		final var enchants = getEnchantments();
		if (enchants == null) {
			return null;
		}

		for (int i = 0; i < enchants.m_8051737(); i++) {
			if (enchants.m_1469498(i).m_9488035("id") == id) {
				return enchants.m_1469498(i);
			}
		}

		return null;
	}

	@Override
	public int br$getEnchantment(AxoEnchant enchant) {
		Preconditions.checkArgument(enchant != null, "enchant != null");
		final var data = axolotlclient$getEnchantment(((C_0230498) enchant).f_9135097);
		return data == null ? 0 : data.m_9488035("lvl");
	}

	@Override
	public void br$setEnchantment(AxoEnchant enchant, int level) {
		Preconditions.checkArgument(enchant != null, "enchant != null");
		Preconditions.checkArgument(level > 1, "level > 1");

		int id = ((C_0230498) enchant).f_9135097;
		final var data = axolotlclient$getEnchantment(id);

		if (data == null) {
			addEnchantment(C_0230498.m_1591793(id), level);
		} else {
			data.m_2856679("lvl", (short) level);
		}
	}

	@Override
	public void br$removeEnchantment(AxoEnchant enchant) {
		final var enchants = getEnchantments();
		if (enchants == null) {
			return;
		}

		int id = ((C_0230498) enchant).f_9135097;

		for (int i = 0; i < enchants.m_8051737(); i++) {
			if (enchants.m_1469498(i).m_9488035("id") == id) {
				enchants.m_8443996(i);
				break;
			}
		}
	}

	@Override
	public AxoText br$getHoverName() {
		return AxoText.literal(getHoverName());
	}
}
