/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.item;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.unmapped.C_2454309;
import net.minecraft.unmapped.C_7400754;
import io.github.axolotlclient.bridge.impl.Bridge;
import io.github.axolotlclient.bridge.item.AxoItemStack;
import io.github.axolotlclient.bridge.item.AxoPlayerInventory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(C_7400754.class)
public abstract class PlayerInventoryMixin implements AxoPlayerInventory {
	@Shadow
	public abstract C_2454309 getMainHandStack();

	@Shadow
	public abstract int getSize();

	@Shadow
	public abstract C_2454309 getStack(int slot);

	@Shadow
	public abstract C_2454309 getArmor(int par1);

	@Shadow
	public C_2454309[] inventorySlots;

	@Override
	public AxoItemStack br$getMainHand() {
		return Bridge.wrapStack(getMainHandStack());
	}

	@Override
	public List<AxoItemStack> br$getItems() {
		return IntStream.range(0, getSize())
			.mapToObj(x -> Bridge.wrapStack(getStack(x)))
			.toList();
	}

	@Override
	public List<AxoItemStack> br$getArmor() {
		return IntStream.range(0, 4)
			.mapToObj(x -> Bridge.wrapStack(getArmor(x)))
			.toList();
	}

	@Override
	public List<? extends AxoItemStack> br$getNonEquipmentItems() {
		return Arrays.stream(inventorySlots)
			.skip(9)
			.map(Bridge::wrapStack)
			.toList();
	}
}
