/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.render;

import io.github.axolotlclient.bridge.render.AxoFont;
import io.github.axolotlclient.bridge.util.AxoText;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_9550253;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(C_3831727.class)
public abstract class TextRendererMixin implements AxoFont {
	@Shadow
	public abstract int draw(String string, float f, float g, int i, boolean bl);

	@Shadow
	public int fontHeight;

	@Shadow
	public abstract int getWidth(String string);

	@Override
	public int br$getWidth(AxoText text) {
		return this.br$getWidth(((C_9550253) text).m_6222303());
	}

	@Override
	public int br$getWidth(String text) {
		return this.getWidth(text);
	}

	/*
	public int br$drawString(AxoRenderContext render, String value, int x, int y, int color, boolean shadow) {
		return draw(value, x, y, color, shadow);
	}

	public void br$drawCenteredString(AxoRenderContext context, String value, int x, int y, int color, boolean
	shadow) {
		draw(value, x - (float) getWidth(value) / 2, y, color, shadow);
	}
*/
	@Override
	public int br$getFontHeight() {
		return fontHeight;
	}
}
