/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.resource;


import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1676943;
import net.minecraft.unmapped.C_6577431;
import io.github.axolotlclient.bridge.resource.AxoResource;
import io.github.axolotlclient.bridge.resource.AxoResourceManager;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.moehreag.searchInResources.SearchableResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(C_6577431.class)
public interface ResourceManagerMixin extends AxoResourceManager {

	@Shadow
	C_1676943 getResource(C_0561170 identifier) throws IOException;

	@SuppressWarnings("unchecked")
	@Override
	default Map<AxoIdentifier, AxoResource> br$listResources(String namespace, String prefix, Predicate<AxoIdentifier> filter) {
		// this cast is maybe not ideal
		return (Map<AxoIdentifier, AxoResource>) (Object) ((SearchableResourceManager) this).findResources(namespace, prefix, filter::test);
	}

	@Override
	default AxoResource br$getResource(AxoIdentifier loc) throws IOException {
		return getResource((C_0561170) loc);
	}
}
