/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.util;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.bridge.util.AxoText;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_5008376;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_9550253;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_6237110.class)
public abstract class StyleMixin implements AxoText.Style {
	@Unique
	@Nullable
	private Integer axolotlclient$color;

	@Shadow
	public abstract C_6237110 copy();

	@Shadow
	public abstract C_6237110 setHoverEvent(C_5008376 par1);

	@Shadow
	public abstract C_6237110 setColor(C_1945050 par1);

	@Shadow
	private C_6237110 parent;

	@Shadow
	protected abstract C_6237110 getParent();

	@Shadow
	@Final
	private static C_6237110 ROOT;

	@Override
	public AxoText.Style br$color(AxoText.Color color) {
		return copy().m_0282611(switch (color) {
			case BLACK -> C_1945050.f_2113304;
			case DARK_BLUE -> C_1945050.f_2702167;
			case DARK_GREEN -> C_1945050.f_1377263;
			case DARK_AQUA -> C_1945050.f_2296475;
			case DARK_RED -> C_1945050.f_3447522;
			case DARK_PURPLE -> C_1945050.f_8162691;
			case GOLD -> C_1945050.f_0313642;
			case GRAY -> C_1945050.f_7540461;
			case DARK_GRAY -> C_1945050.f_2985643;
			case BLUE -> C_1945050.f_7743109;
			case GREEN -> C_1945050.f_7735202;
			case AQUA -> C_1945050.f_0440484;
			case RED -> C_1945050.f_9213701;
			case LIGHT_PURPLE -> C_1945050.f_3614776;
			case YELLOW -> C_1945050.f_6222183;
			case WHITE -> C_1945050.f_5887713;
		});
	}

	@Override
	public AxoText.Style br$color(int color) {
		final var copy = copy();
		((StyleMixin) (Object) copy).axolotlclient$color = color;
		return copy;
	}

	@Unique
	private Integer axolotlclient$getColor() {
		if (((Object) this) == ROOT) return null;
		if (axolotlclient$color == null) {
			return ((StyleMixin) (Object) getParent()).axolotlclient$getColor();
		}
		return axolotlclient$color;
	}

	@ModifyReturnValue(method = "copy", at = @At("RETURN"))
	public C_6237110 copyColor(C_6237110 original) {
		((StyleMixin) (Object) original).axolotlclient$color = axolotlclient$getColor();
		return original;
	}

	@ModifyReturnValue(method = "deepCopy", at = @At("RETURN"))
	public C_6237110 deepCopyColor(C_6237110 original) {
		((StyleMixin) (Object) original).axolotlclient$color = axolotlclient$color;
		return original;
	}

	@Override
	public AxoText.Style br$tooltip(AxoText text) {
		return copy().m_3975477(new C_5008376(C_5008376.C_4842797.f_5996706, (C_9550253) text));
	}

	@Inject(method = "asString", at = @At(value = "INVOKE", target = "Lnet/minecraft/text/Style;isBold()Z"))
	private void formatColorCode(CallbackInfoReturnable<String> cir, @Local StringBuilder sb) {
		Integer color = axolotlclient$getColor();

		if (color != null) {
			sb.append("§#").append(StringUtils.leftPad(Integer.toUnsignedString(color & 0xffffff, 16), 6, "0"));
		}
	}

	@WrapMethod(method = "isEmpty")
	private boolean isEmptyColor(Operation<Boolean> original) {
		return original.call() && axolotlclient$color == null;
	}
}
