/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.util;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.unmapped.C_9550253;
import io.github.axolotlclient.bridge.util.AxoText;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(C_9550253.class)
public interface TextMixin extends AxoText.Mutable {
	@Shadow
	C_9550253 append(C_9550253 par1);

	@Shadow
	C_9550253 setStyle(net.minecraft.unmapped.C_6237110 par1);

	@Shadow
	String getString();

	@Shadow
	C_9550253 copy();

	@Shadow
	String getContent();

	@Shadow
	net.minecraft.unmapped.C_6237110 getStyle();

	@Shadow
	List<C_9550253> getSiblings();

	@Override
	default Mutable br$append(AxoText child) {
		return append(((C_9550253) child).m_6415269());
	}

	@Override
	default Mutable br$setStyle(Style style) {
		return setStyle((net.minecraft.unmapped.C_6237110) style);
	}

	@Override
	default String br$getRawString() {
		return getString();
	}

	@Override
	default AxoText.Mutable br$copy() {
		return copy();
	}

	@Override
	default void br$visit(BiConsumer<String, AxoText.Style> handler) {
		handler.accept(getContent(), getStyle());

		for (C_9550253 c : getSiblings()) {
			c.br$visit(handler);
		}
	}

	@Override
	default AxoText.Style br$getStyle() {
		return getStyle();
	}
}
