/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.world;

import java.util.Collections;
import java.util.List;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_6928498;
import net.minecraft.unmapped.C_9590849;
import io.github.axolotlclient.bridge.entity.AxoPlayer;
import io.github.axolotlclient.bridge.math.Vec3;
import io.github.axolotlclient.bridge.world.AxoWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(C_5553933.class)
public abstract class WorldMixin implements AxoWorld {
	@Shadow
	public abstract long getTimeOfDay();

	@Shadow
	@Final
	public List<C_9590849> players;

	@Shadow
	public abstract C_6928498 getBiome(C_3674802 blockPos);

	@Override
	public long br$getTimeOfDay() {
		return getTimeOfDay();
	}

	@Override
	public List<? extends AxoPlayer> br$getPlayers() {
		return Collections.unmodifiableList(this.players);
	}

	@Override
	public String br$getBiomeName(Vec3 pos) {
		return getBiome(new C_3674802(pos.x(), pos.y(), pos.z())).f_2049602;
	}
}
