/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.config.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0631682;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_6237110;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8529493;
import net.minecraft.unmapped.C_9550253;
import net.minecraft.unmapped.C_9588086;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.PlainTextButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.bridge.util.AxoText;
import io.github.axolotlclient.credits.Credits;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.RenderUtil;
import io.github.axolotlclient.util.ClientColors;

public class CreditsScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {

	public static final HashMap<String, String[]> externalModuleCredits = new HashMap<>();
	private final C_3020744 parent;
	private final C_9588086 bgm = C_0631682.m_4527928(new C_0561170("minecraft", "records.chirp"));

	public CreditsScreen(C_3020744 parent) {
		super(C_3390001.m_2053009("credits"));
		this.parent = parent;
	}

	@Override
	public void m_7817195() {
		if (AxolotlClient.config().someNiceBackground.get()) { // Credit to pridelib for the colors
			m_7865719(0, 0, f_5465691, f_3080061 / 6, 0xFFff0018);
			m_7865719(0, f_3080061 / 6, f_5465691, f_3080061 * 2 / 6, 0xFFffa52c);
			m_7865719(0, f_3080061 * 2 / 6, f_5465691, f_3080061 / 2, 0xFFffff41);
			m_7865719(0, f_3080061 * 2 / 3, f_5465691, f_3080061 * 5 / 6, 0xFF0000f9);
			m_7865719(0, f_3080061 / 2, f_5465691, f_3080061 * 2 / 3, 0xFF008018);
			m_7865719(0, f_3080061 * 5 / 6, f_5465691, f_3080061, 0xFF86007d);
		} else {
			super.m_7817195();
		}
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_7817195();
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, getTitle(), f_5465691 / 2, 33 / 2 - f_2020658.f_6725889 / 2, -1);
	}

	@Override
	public void m_3593494() {
		addDrawableChild(new CreditsList(f_7153641, f_5465691, f_3080061, f_3080061 - 33 - 33, 33, 25));

		var back = addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 75, f_3080061 - 33 / 2 - 20 / 2, 150, 20,
			C_3390001.m_2053009("gui.back"), buttonWidget -> closeScreen()));

		addDrawableChild(new VanillaButtonWidget(6, back.getY(), 100, 20, C_3390001.m_2053009("creditsBGM") + ": "
			+ C_3390001.m_2053009(AxolotlClient.config().creditsBGM.get() ? "options.on" : "options.off"),
			buttonWidget -> {
				AxolotlClient.config().creditsBGM.toggle();
				AxolotlClient.getInstance().getConfigManager().save();
				stopBGM();
				buttonWidget.setMessage(C_3390001.m_2053009("creditsBGM") + ": " +
					C_3390001.m_2053009(AxolotlClient.config().creditsBGM.get() ? "options.on" : "options.off"));
			}));
	}

	public void closeScreen() {
		f_7153641.m_6408915(parent);
		stopBGM();
	}

	@Override
	public void m_2450377() {
		tickBGM();
	}

	public void tickBGM() {
		if (AxolotlClient.config().creditsBGM.get() && !f_7153641.m_7555106().m_3514830(bgm)) {
			f_7153641.m_7555106().m_3137170(bgm);
		}
	}

	private void stopBGM() {
		f_7153641.m_7555106().m_6064169(bgm);
	}

	private class CreditsList extends ElementListWidget<io.github.axolotlclient.config.screen.CreditsScreen.Entry> {

		public CreditsList(C_8105098 minecraftClient, int width, int screenHeight, int height, int top,
						   int entryHeight) {
			super(minecraftClient, width, height, top, top + height, entryHeight);

			addEntry(new SpacerTitle("- - - - - - " + C_3390001.m_2053009("contributors") + " - - - - - -"));
			Credits.getContributors().forEach(credit -> addEntry(new Credit(credit.getName(), credit.getThings())));

			addEntry(new SpacerTitle("- - - - - - " + C_3390001.m_2053009("other_people") + " - - - - - -"));
			Credits.getOtherPeople().forEach(credit -> addEntry(new Credit(credit.getName(), credit.getThings())));

			if (!externalModuleCredits.isEmpty()) {
				addEntry(new SpacerTitle("- - - - - - " + C_3390001.m_2053009("external_modules") + " - - - - - -"));
				externalModuleCredits.forEach((s, s2) -> addEntry(new Credit(s, s2)));
			}
		}
	}

	private abstract static class Entry extends ElementListWidget.Entry<Entry> {

	}

	private class Credit extends Entry {

		private final String name;
		private final String[] things;
		private final VanillaButtonWidget c;

		public Credit(String name, String... things) {
			this.name = name;
			this.things = things;
			c = new VanillaButtonWidget(0, 0, 200, 20, name, buttonWidget -> f_7153641.m_6408915(new CreditOverlay(this))) {
				@Override
				protected void drawWidget(int mouseX, int mouseY, float delta) {
					if (isHovered()) {
						RenderUtil.drawOutline(getX(), getY(), getWidth(), getHeight(), ClientColors.ERROR.toInt());
					}
					var i = this.active ? (isHovered() ? ClientColors.SELECTOR_RED : ClientColors.WHITE) : ClientColors.GRAY;
					this.drawScrollingText(f_2020658, 2, i);
				}
			};
		}

		@Override
		public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX,
						   int mouseY, boolean hovered, float tickDelta) {
			c.setPosition(x, y);
			c.render(mouseX, mouseY, tickDelta);
		}

		@Override
		public List<? extends Element> children() {
			return List.of(c);
		}
	}

	private class CreditOverlay extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {
		private final Credit credit;
		private final List<Runnable> lines = new ArrayList<>();

		public CreditOverlay(Credit credit) {
			super(C_3390001.m_2053009(credit.name));
			this.credit = credit;
		}


		public void closeScreen() {
			f_7153641.m_6408915(CreditsScreen.this);
		}

		@Override
		public void m_3593494() {
			int startY = 100;
			for (String t : credit.things) {
				int textWidth = f_2020658.br$getWidth(t);
				if (t.startsWith("http")) {
					addDrawableChild(new PlainTextButtonWidget(f_5465691 / 2 - textWidth / 2, startY, textWidth, 12,
						((C_9550253) AxoText.literal(t).br$color(ClientColors.SELECTOR_GREEN)).m_2117196(), btn -> {
						m_9528629(new C_1716360("").m_7551367(new C_6237110().m_7701784(new C_8529493(C_8529493.C_4892378.f_1413720, t))));
					}, f_2020658));
				} else {
					int y = startY;
					lines.add(() -> f_2020658.m_4683674(t, f_5465691 / 2 - textWidth / 2, y,
						ClientColors.SELECTOR_GREEN.toInt()));
				}
				startY += 12;
			}
			addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 75, f_3080061 - 33 / 2 - 10, 150, 20, C_3390001.m_2053009("gui.back"), buttonWidget -> closeScreen()));
		}

		@Override
		public void m_7817195() {
			super.m_7817195();
			RenderUtil.drawRectangle(100, 50, f_5465691 - 200, f_3080061 - 100,
				ClientColors.DARK_GRAY.withAlpha(127));
			DrawUtil.outlineRect(100, 50, f_5465691 - 200, f_3080061 - 100,
				ClientColors.BLACK.toInt());
		}

		@Override
		public void m_7261014(int mouseX, int mouseY, float delta) {
			super.m_7261014(mouseX, mouseY, delta);
			m_2717572(f_2020658, credit.name,
				f_5465691 / 2, 57, -16784327);
			lines.forEach(Runnable::run);
		}

		@Override
		public void m_2450377() {
			CreditsScreen.this.tickBGM();
		}
	}

	private class SpacerTitle extends Entry {

		private final String name;

		public SpacerTitle(String name) {
			this.name = name;
		}

		@Override
		public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX,
						   int mouseY, boolean hovered, float tickDelta) {
			CreditsScreen.this.m_2717572(f_2020658, name, x + entryWidth / 2, y, -128374);
		}

		@Override
		public List<? extends Element> children() {
			return List.of();
		}
	}
}
