/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import net.minecraft.unmapped.C_2313930;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_6697291;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(C_2313930.class)
public abstract class BiPedModelMixin {

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/model/ModelPart;render(F)V", ordinal = 6))
	public void axolotlclient$translucentHatOne(C_6697291 instance, float scale) {
		C_3754158.m_8373640();

		C_3754158.m_3445676();
		C_3754158.m_9671730();
		C_3754158.m_2076358(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		instance.m_3467157(scale);
		C_3754158.m_5313301();
		C_3754158.m_9671730();
		C_3754158.m_6418746();

		C_3754158.m_2041265();
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/model/ModelPart;render(F)V", ordinal = 13))
	public void axolotlclient$translucentHatTwo(C_6697291 instance, float scale) {
		C_3754158.m_8373640();

		C_3754158.m_3445676();
		C_3754158.m_9671730();
		C_3754158.m_2076358(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
		instance.m_3467157(scale);
		C_3754158.m_5313301();
		C_3754158.m_9671730();
		C_3754158.m_6418746();

		C_3754158.m_2041265();
	}
}
