/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.UUID;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.bridge.events.Events;
import net.minecraft.network.packet.s2c.play.*;
import net.minecraft.unmapped.C_0814381;
import net.minecraft.unmapped.C_1234758;
import net.minecraft.unmapped.C_3027966;
import net.minecraft.unmapped.C_3543146;
import net.minecraft.unmapped.C_3945557;
import net.minecraft.unmapped.C_4143404;
import net.minecraft.unmapped.C_4804187;
import net.minecraft.unmapped.C_5722573;
import net.minecraft.unmapped.C_7873567;
import net.minecraft.unmapped.C_8442234;
import net.minecraft.unmapped.C_8475339;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(C_5722573.class)
public abstract class ClientPlayNetworkHandlerMixin {

	@Shadow
	private C_7873567 world;

	@Shadow
	public abstract C_3543146 getOnlinePlayer(UUID uUID);

	@Inject(method = "handleWorldTime", at = @At("HEAD"))
	private void axolotlclient$onWorldUpdate(C_8442234 packet, CallbackInfo ci) {
		Events.UPDATE_TIME.invoker().accept(packet.m_4997146());
	}

	@Inject(method = "handleTeam", at = @At(value = "INVOKE", target = "Lnet/minecraft/scoreboard/Scoreboard;removeTeam(Lnet/minecraft/scoreboard/team/Team;)V"), cancellable = true)
	private void noStackTraceOnNullTeam(C_8475339 teamS2CPacket, CallbackInfo ci, @Local C_4143404 team) {
		if (team == null) {
			ci.cancel();
		}
	}

	@WrapOperation(method = "handleTeam", at = @At(value = "INVOKE", target = "Lnet/minecraft/scoreboard/Scoreboard;addTeam(Ljava/lang/String;)Lnet/minecraft/scoreboard/team/Team;"))
	private C_4143404 noStackTraceOnAlreadyExistingTeam(C_0814381 instance, String s, Operation<C_4143404> original, @Local C_0814381 scoreboard) {
		C_4143404 team = scoreboard.m_4614828(s);
		if (team == null) {
			return original.call(instance, s);
		}
		return team;
	}

	@Inject(method = "handleScoreboardObjective", at = @At(value = "INVOKE", target = "Lnet/minecraft/scoreboard/Scoreboard;removeObjective(Lnet/minecraft/scoreboard/ScoreboardObjective;)V"), cancellable = true)
	private void noStackTraceOnNullScoreboardObjective(C_1234758 scoreboardObjectiveS2CPacket, CallbackInfo ci, @Local C_3945557 objective) {
		if (objective == null) {
			ci.cancel();
		}
	}

	@Inject(method = "handleEntityTeleport", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/world/ClientWorld;getEntity(I)Lnet/minecraft/entity/Entity;"), cancellable = true)
	private void noStackTraceOnNullWorld(C_4804187 entityTeleportS2CPacket, CallbackInfo ci) {
		if (this.world == null) {
			ci.cancel();
		}
	}

	@Inject(method = "handleAddPlayer", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/entity/living/player/RemoteClientPlayerEntity;<init>(Lnet/minecraft/world/World;Lcom/mojang/authlib/GameProfile;)V"), cancellable = true)
	private void noStackTraceonNotOnlinePlayer(C_3027966 addPlayerS2CPacket, CallbackInfo ci) {
		if (getOnlinePlayer(addPlayerS2CPacket.m_3894595()) == null) {
			ci.cancel();
		}
	}
}
