/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.freelook.Perspective;
import io.github.axolotlclient.modules.hypixel.LevelHead;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsMod;
import io.github.axolotlclient.util.BadgeRenderer;
import io.github.axolotlclient.util.Util;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_3362006;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_7106153;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import net.minecraft.unmapped.C_8980628;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(C_8980628.class)
public abstract class EntityRendererMixin<T extends C_0539808> {

	@Shadow
	@Final
	protected C_3362006 dispatcher;

	@Inject(method = "renderNameTag(Lnet/minecraft/entity/Entity;Ljava/lang/String;DDDI)V", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;rotatef(FFFF)V", ordinal = 1))
	private void axolotlclient$correctNameplateRotation(C_0539808 entity, String string, double d, double e, double f, int i, CallbackInfo ci) {
		if (C_8105098.m_0408063().f_9967940.f_3094045 == Perspective.THIRD_PERSON_FRONT.ordinal()) {
			C_3754158.m_8616673(-this.dispatcher.f_2592027 * 2, 1.0F, 0.0F, 0.0F);
		}
	}

	@Inject(method = "renderNameTag(Lnet/minecraft/entity/Entity;Ljava/lang/String;DDDI)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;draw(Ljava/lang/String;III)I", ordinal = 1))
	public void axolotlclient$addBadges(T entity, String string, double d, double e, double f, int i, CallbackInfo ci) {
		if (entity instanceof C_7106153 && string.equals(entity.m_0699887().m_2117196()))
			BadgeRenderer.renderNametagBadge(entity);
	}

	@WrapOperation(method = "renderNameTag(Lnet/minecraft/entity/Entity;Ljava/lang/String;DDDI)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;draw(Ljava/lang/String;III)I", ordinal = 1))
	public int axolotlclient$forceShadows(C_3831727 instance, String string, int x, int y, int color, Operation<Integer> original, C_0539808 entity) {
		if (AxolotlClient.config().useShadows.get() && !entity.m_4153657()) {
			return instance.m_4413321(string, x, y, color, true);
		}
		return original.call(instance, string, x, y, color);
	}

	@Inject(method = "renderNameTag(Lnet/minecraft/entity/Entity;Ljava/lang/String;DDDI)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;draw(Ljava/lang/String;III)I", ordinal = 1))
	public void axolotlclient$addLevel(T entity, String string, double d, double e, double f, int i, CallbackInfo ci) {
		if (entity instanceof C_7106153 && string.equals(entity.m_0699887().m_2117196())) {
			if (Util.currentServerAddressContains("hypixel.net")) {
				if (BedwarsMod.getInstance().isEnabled() &&
					BedwarsMod.getInstance().inGame() &&
					BedwarsMod.getInstance().bedwarsLevelHead.get()) {
					String levelhead = BedwarsMod.getInstance().getGame().get().getLevelHead((C_7106153) entity);
					if (levelhead != null) {
						axolotlclient$drawLevelHead(levelhead);
					}
				} else if (LevelHead.getInstance().enabled.get()) {
					String text = LevelHead.getInstance().getDisplayString(entity.m_2013188().toString());

					axolotlclient$drawLevelHead(text);
				}
			}
		}
	}

	@Unique
	private void axolotlclient$drawLevelHead(String text) {
		C_3831727 textRenderer = C_8105098.m_0408063().f_0426313;

		float x = textRenderer.m_0040387(text) / 2F;
		int y = text.contains("deadmau5") ? -20 : -10;

		if (LevelHead.getInstance().background.get()) {
			y -= 2;
		}

		if (LevelHead.getInstance().background.get()) {
			C_5786166 tessellator = C_5786166.m_2065116();
			C_8373595 bufferBuilder = tessellator.m_1454391();
			C_3754158.m_2090124();
			bufferBuilder.m_0421390(7, C_4461663.f_8459667);
			bufferBuilder.m_3299851(-x - 1, -1 + y, 0.0).m_3978312(0.0F, 0.0F, 0.0F, 0.25F).m_4365807();
			bufferBuilder.m_3299851(-x - 1, 8 + y, 0.0).m_3978312(0.0F, 0.0F, 0.0F, 0.25F).m_4365807();
			bufferBuilder.m_3299851(x + 1, 8 + y, 0.0).m_3978312(0.0F, 0.0F, 0.0F, 0.25F).m_4365807();
			bufferBuilder.m_3299851(x + 1, -1 + y, 0.0).m_3978312(0.0F, 0.0F, 0.0F, 0.25F).m_4365807();
			tessellator.m_8222644();
			C_3754158.m_7547086();
		}

		textRenderer.m_4413321(text, -x, y, LevelHead.getInstance().textColor.get().toInt(),
			AxolotlClient.config().useShadows.get());
	}

	@Redirect(method = "renderNameTag(Lnet/minecraft/entity/Entity;Ljava/lang/String;DDDI)V", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/vertex/BufferBuilder;vertex(DDD)Lcom/mojang/blaze3d/vertex/BufferBuilder;"))
	public C_8373595 axolotlclient$noBg(C_8373595 instance, double d, double e, double f) {
		if (AxolotlClient.config().nametagBackground.get()) {
			instance.m_3299851(d, e, f);
		}
		return instance;
	}
}
