/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.Objects;

import io.github.axolotlclient.AxolotlClientConfigCommon;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.APIOptions;
import io.github.axolotlclient.api.ChatsSidebar;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.modules.hypixel.HypixelAbstractionLayer;
import io.github.axolotlclient.modules.hypixel.HypixelMods;
import io.github.axolotlclient.util.FeatureDisabler;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_7077203;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(C_7077203.class)
public abstract class GameMenuScreenMixin extends C_3020744 {

	private static boolean axolotlclient$hasModMenu() {
		return FabricLoader.getInstance().isModLoaded("modmenu") && !FabricLoader.getInstance().isModLoaded("axolotlclient-modmenu");
	}

	@Inject(method = "init", at = @At("RETURN"))
	public void axolotlclient$addConfigButton(CallbackInfo ci) {
		if (API.getInstance().isAuthenticated()) {
			int buttonY = f_3080061 - 30;
			if (APIOptions.getInstance().addShortcutButtons.get()) {
				f_2213969.add(new C_2348249(134, 10, buttonY, 75, 20, C_3390001.m_2053009("api.friends")));
				buttonY -= 25;
			}
			f_2213969.add(new C_2348249(234, 10, buttonY, 75, 20, C_3390001.m_2053009("api.chats")));
		}

		if (!AxolotlClientConfigCommon.instance().gameMenuScreenOptionButtonMode.get().showButton())
			return;

		if (f_7153641.m_9805322() && !this.f_7153641.m_4351464().m_0662401()) {
			f_2213969.add(new C_2348249(20, f_5465691 / 2 - 100,
				f_3080061 / 4 + 82,
				C_3390001.m_2053009("config")));
			for (C_2348249 button : f_2213969) {
				if (button.f_8532347 >= this.f_3080061 / 4 - 16 + 24 * 4 - 1 && button.f_5920996 < 20) {
					button.f_8532347 += 24;
				}
				//button.y -= 12;
			}
		} else {
			for (C_2348249 button : f_2213969) {
				if (!button.f_3831222 && button.f_5920996 == 20) {
					button.f_3831222 = true;
				}
			}
		}
	}

	@ModifyArgs(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/widget/ButtonWidget;<init>(IIIIILjava/lang/String;)V", ordinal = 1))
	public void axolotlclient$addOptionsButton(Args args) {
		if (axolotlclient$hasModMenu())
			return;

		if (!f_7153641.m_9805322() && ((f_7153641.m_4351464() != null
			&& f_7153641.m_4351464().m_0662401())
			|| f_7153641.m_1862495() != null)) {
			args.set(0, 20);
			args.set(5, C_3390001.m_2053009("title_short"));
		}
	}

	@Inject(method = "buttonClicked", at = @At("HEAD"))
	public void axolotlclient$customButtons(C_2348249 button, CallbackInfo ci) {
		if (button.f_5920996 == 20 && !axolotlclient$hasModMenu()) {
			f_7153641.m_6408915(new HudEditScreen(this));
		} else if (button.f_5920996 == 1) {
			FeatureDisabler.clear();
			if (HypixelMods.getInstance().cacheMode.get() != null
				&& Objects.equals(HypixelMods.getInstance().cacheMode.get(),
				HypixelMods.HypixelApiCacheMode.ON_CLIENT_DISCONNECT.toString())) {
				HypixelAbstractionLayer.getInstance().clearPlayerData();
			}
		} else if (button.f_5920996 == 234) {
			f_7153641.m_6408915(new ChatsSidebar(this));
		} else if (button.f_5920996 == 134) {
			f_7153641.m_6408915(new FriendsScreen(this));
		}
	}
}
