/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.nio.FloatBuffer;
import net.minecraft.unmapped.C_0259655;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_1023567;
import net.minecraft.unmapped.C_1197137;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_1331819;
import net.minecraft.unmapped.C_1400833;
import net.minecraft.unmapped.C_3488550;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5585855;
import net.minecraft.unmapped.C_6607881;
import net.minecraft.unmapped.C_8048208;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9590849;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.blur.MenuBlur;
import io.github.axolotlclient.modules.blur.MotionBlur;
import io.github.axolotlclient.modules.freelook.Freelook;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.vanilla.CrosshairHud;
import io.github.axolotlclient.modules.hypixel.Skyblock;
import io.github.axolotlclient.modules.sky.SkyboxManager;
import io.github.axolotlclient.modules.unfocusedFpsLimiter.UnfocusedFpsLimiter;
import io.github.axolotlclient.modules.zoom.Zoom;
import io.github.axolotlclient.util.notifications.Notifications;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(C_0259655.class)
public abstract class GameRendererMixin {

	@Shadow
	private C_8105098 minecraft;
	@Shadow
	private float viewDistance;
	@Shadow
	private float fogRed;
	@Shadow
	private float fogGreen;
	@Shadow
	private float fogBlue;
	@Shadow
	private boolean thiccFog;
	@Shadow
	private boolean debugCamera;

	@Shadow
	protected abstract FloatBuffer setFogColor(float par1, float par2, float par3, float par4);


	@Inject(method = "renderFog", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$noFog(int i, float tickDelta, CallbackInfo ci) {
		if (C_8105098.m_0408063().f_4601986.f_6669533.m_4324221() && AxolotlClient.config().customSky.get()
			&& SkyboxManager.getInstance().hasSkyBoxes()) {
			this.viewDistance = (float) (this.viewDistance * 2 + C_8105098.m_0408063().f_7663840.m_5275640().f_7064947);
			C_0539808 entity = this.minecraft.m_5661944();

			GL11.glFogfv(2918, this.setFogColor(this.fogRed, this.fogGreen, this.fogBlue, 1.0F));
			GL11.glNormal3f(0.0F, -1.0F, 0.0F);
			C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
			C_1241852 block = C_1400833.m_7179989(this.minecraft.f_4601986, entity, tickDelta);
			if (entity instanceof C_6607881 && ((C_6607881) entity).m_8841439(C_3488550.f_4973727)) {
				float f = 5.0F;
				int j = ((C_6607881) entity).m_6853648(C_3488550.f_4973727).m_8555915();
				if (j < 20) {
					f = 5.0F + (this.viewDistance - 5.0F) * (1.0F - (float) j / 20.0F);
				}

				C_3754158.m_1538155(9729);
				if (i == -1) {
					C_3754158.m_5197721(0.0F);
					C_3754158.m_4671300(f * 0.8F);
				} else {
					C_3754158.m_5197721(f * 0.25F);
					C_3754158.m_4671300(f);
				}

				if (GLContext.getCapabilities().GL_NV_fog_distance) {
					GL11.glFogi(34138, 34139);
				}
			} else if (this.thiccFog) {
				C_3754158.m_1538155(2048);
				C_3754158.m_5403807(0.1F);
			} else if (block.m_8228353() == C_8048208.f_0913582) {
				C_3754158.m_1538155(2048);
				if (entity instanceof C_6607881
					&& ((C_6607881) entity).m_8841439(C_3488550.f_7878667)) {
					C_3754158.m_5403807(0.01F);
				} else {
					C_3754158.m_5403807(0.1F - (float) C_1197137.m_1914566(entity) * 0.03F);
				}
			} else if (block.m_8228353() == C_8048208.f_7949049) {
				C_3754158.m_1538155(2048);
				C_3754158.m_5403807(2.0F);
			} else {
				float f = this.viewDistance;
				C_3754158.m_1538155(9729);
				C_3754158.m_5197721(f - 0.01F);
				C_3754158.m_4671300(f);

				if (this.minecraft.f_4601986.f_6669533.m_8718041((int) entity.f_6638345, (int) entity.f_9103758)) {
					C_3754158.m_5197721(f * 0.05F);
					C_3754158.m_4671300(Math.min(f, 192.0F) * 0.5F);
				}
			}

			C_3754158.m_7424052();
			C_3754158.m_8700923();
			C_3754158.m_9862625(1028, 4608);
			ci.cancel();
		}
	}

	@Inject(method = "getFov", at = @At(value = "RETURN"), cancellable = true)
	public void axolotlclient$setZoom(float tickDelta, boolean changingFov, CallbackInfoReturnable<Float> cir) {

		if (debugCamera) {
			return;
		}

		Zoom.update();

		float returnValue = cir.getReturnValue();

		if (!AxolotlClient.config().dynamicFOV.get()) {
			C_0539808 entity = this.minecraft.m_5661944();
			float f = changingFov ? minecraft.f_9967940.f_7544507 : 70F;
			if (entity instanceof C_6607881 && ((C_6607881) entity).m_8116444() <= 0.0F) {
				float g = (float) ((C_6607881) entity).f_0351419 + tickDelta;
				f /= (1.0F - 500.0F / (g + 500.0F)) * 2.0F + 1.0F;
			}

			C_1241852 block = C_1400833.m_7179989(this.minecraft.f_4601986, entity, tickDelta);
			if (block.m_8228353() == C_8048208.f_0913582) {
				f = f * 60.0F / 70.0F;
			}
			returnValue = f;
		}

		returnValue = (float) Zoom.getFov(returnValue, tickDelta);

		cir.setReturnValue(returnValue);
	}

	@Redirect(method = "updateLightMap", at = @At(value = "FIELD", target = "Lnet/minecraft/client/options/GameOptions;gamma:F", opcode = Opcodes.GETFIELD))
	public float axolotlclient$setGamma(C_1331819 instance) {
		if (AxolotlClient.config().fullBright.get())
			return 15F;
		return instance.f_5541398;
	}

	@Inject(method = "renderAxisIndicators", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$customCrosshairF3(float tickDelta, CallbackInfo ci) {
		CrosshairHud hud = (CrosshairHud) HudManager.getInstance().get(CrosshairHud.ID);
		if (hud.isEnabled() && this.minecraft.f_9967940.f_0893418 && !this.minecraft.f_9967940.f_8058174
			&& hud.overridesF3()) {
			ci.cancel();
		}
	}

	@Inject(method = "render(FJ)V", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/pipeline/RenderTarget;bindWrite(Z)V"))
	public void axolotlclient$worldMotionBlur(float tickDelta, long nanoTime, CallbackInfo ci) {
		MenuBlur.getInstance().updateBlur();
		axolotlclient$postRender(tickDelta, nanoTime, null);
	}

	@Inject(method = "render(FJ)V", at = @At("TAIL"))
	private void renderNotifications(float f, long l, CallbackInfo ci) {
		Notifications.getInstance().getToastManager().render();
	}

	@Inject(method = "render(FJ)V", at = @At("TAIL"))
	public void axolotlclient$postRender(float tickDelta, long nanoTime, CallbackInfo ci) {
		if ((ci == null) == MotionBlur.getInstance().inGuis.get()) {
			return;
		}

		this.minecraft.f_3960058.m_8238460("Motion Blur");

		if (MotionBlur.getInstance().enabled.get() && C_5585855.f_7115152) {
			MotionBlur blur = MotionBlur.getInstance();
			blur.onUpdate();
			blur.shader.m_0877167(tickDelta);
		}

		this.minecraft.f_3960058.m_8388219();
	}

	@WrapOperation(method = "render(FJ)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/entity/living/player/LocalClientPlayerEntity;updateLocalPlayerCamera(FF)V"))
	public void axolotlclient$updateRotation(C_1023567 instance, float yaw, float pitch, Operation<Void> original) {
		Freelook freelook = Freelook.getInstance();

		if (freelook.consumeRotation(yaw, pitch) || Skyblock.getInstance().rotationLocked.get())
			return;

		original.call(instance, yaw, pitch);
	}

	@Redirect(method = "transformCamera", at = @At(value = "FIELD", target = "Lnet/minecraft/entity/Entity;yaw:F"))
	public float axolotlclient$freelook$yaw(C_0539808 entity) {
		return Freelook.getInstance().yaw(entity.f_7165431);
	}

	@Redirect(method = "transformCamera", at = @At(value = "FIELD", target = "Lnet/minecraft/entity/Entity;prevYaw:F"))
	public float axolotlclient$freelook$prevYaw(C_0539808 entity) {
		return Freelook.getInstance().yaw(entity.f_5055140);
	}

	@Redirect(method = "transformCamera", at = @At(value = "FIELD", target = "Lnet/minecraft/entity/Entity;pitch:F"))
	public float axolotlclient$freelook$pitch(C_0539808 entity) {
		return Freelook.getInstance().pitch(entity.f_0243146);
	}

	@Redirect(method = "transformCamera", at = @At(value = "FIELD", target = "Lnet/minecraft/entity/Entity;prevPitch:F"))
	public float axolotlclient$freelook$prevPitch(C_0539808 entity) {
		return Freelook.getInstance().pitch(entity.f_4249690);
	}

	@Inject(method = "render(FJ)V", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$limitFpsOnLostFocus(float tickDelta, long nanoTime, CallbackInfo ci) {
		if (!UnfocusedFpsLimiter.getInstance().checkForRender()) {
			ci.cancel();
		}
	}

	@Inject(method = "renderSnowAndRain", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$changeWeather(float tickDelta, CallbackInfo ci) {
		if (AxolotlClient.config().noRain.get()) {
			ci.cancel();
		}
	}

	@Inject(method = "applyViewBobbing", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;translatef(FFF)V"), locals = LocalCapture.CAPTURE_FAILHARD, cancellable = true)
	private void axolotlclient$minimalViewBob(float f, CallbackInfo ci, C_9590849 entity, float g, float h, float i, float j) {
		if (AxolotlClient.config().minimalViewBob.get()) {
			h /= 2;
			i /= 2;
			j /= 2;
			C_3754158.m_3172490(C_4976084.m_7865904(h * (float) Math.PI) * i * 0.5F, -Math.abs(C_4976084.m_4847696(h * (float) Math.PI) * i), 0.0F);
			C_3754158.m_8616673(C_4976084.m_7865904(h * (float) Math.PI) * i * 3.0F, 0.0F, 0.0F, 1.0F);
			C_3754158.m_8616673(Math.abs(C_4976084.m_4847696(h * (float) Math.PI - 0.2F) * i) * 5.0F, 1.0F, 0.0F, 0.0F);
			C_3754158.m_8616673(j, 1.0F, 0.0F, 0.0F);
			ci.cancel();
		}
	}

	@Inject(method = "applyHurtCam", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;getCamera()Lnet/minecraft/entity/Entity;", ordinal = 1), cancellable = true)
	private void axolotlclient$noHurtCam(float f, CallbackInfo ci) {
		if (AxolotlClient.config().noHurtCam.get()) {
			ci.cancel();
		}
	}
}
