/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import io.github.axolotlclient.bridge.impl.AxoRenderContextImpl;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.IconHud;
import io.github.axolotlclient.modules.scrollableTooltips.ScrollableTooltips;
import net.minecraft.unmapped.C_2711798;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9639106;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(C_9639106.class)
public abstract class HandledScreenMixin {

	@Shadow
	private C_2711798 hoveredSlot;
	@Unique
	private C_2711798 cachedSlot;

	@Shadow
	protected abstract boolean moveHoveredSlotToHotbar(int i);

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;popMatrix()V"))
	public void axolotlclient$resetScrollOnSlotChange(int mouseX, int mouseY, float tickDelta, CallbackInfo ci) {
		if (ScrollableTooltips.getInstance().enabled.get() && cachedSlot != hoveredSlot) {
			cachedSlot = hoveredSlot;
			ScrollableTooltips.getInstance().resetScroll();
		}
	}

	@Inject(method = "mouseClicked", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$mouseClickedHead(int mouseX, int mouseY, int mouseButton, CallbackInfo ci) {
		if (mouseButton - 100 == C_8105098.m_0408063().f_9967940.f_9316411.m_6463487()) {
			C_8105098.m_0408063().m_5690108();
			ci.cancel();
		}
	}

	@Inject(method = "mouseClicked", at = @At("RETURN"))
	private void axolotlclient$mouseClickedTail(int mouseX, int mouseY, int mouseButton, CallbackInfo ci) {
		moveHoveredSlotToHotbar(mouseButton - 100);
	}

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/inventory/menu/InventoryMenuScreen;drawBackground(FII)V"))
	private void renderIcon(int i, int j, float f, CallbackInfo ci) {
		var hud = (IconHud) HudManager.getInstance().get(IconHud.ID);
		if (hud != null && hud.isEnabled()) {
			hud.renderInGui(AxoRenderContextImpl.getInstance(), f);
		}
	}
}
