/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.ScoreboardRenderEvent;
import io.github.axolotlclient.bridge.impl.AxoRenderContextImpl;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.vanilla.*;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsMod;
import io.github.axolotlclient.util.Util;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_3182765;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_3945557;
import net.minecraft.unmapped.C_7799337;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8651652;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(C_8651652.class)
public abstract class InGameHudMixin {

	@Unique
	private static final C_0539808 axolotlclient$noHungerEntityTM = new C_3182765(null);

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;color4f(FFFF)V", ordinal = 0))
	private void axolotlclient$onHudRender(float tickDelta, CallbackInfo ci) {
		HudManager.getInstance().render(AxoRenderContextImpl.getInstance(), tickDelta);
	}

	@Inject(method = "renderScoreboardObjective", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$customScoreBoard(C_3945557 objective, C_7799337 window, CallbackInfo ci) {
		ScoreboardHud hud = (ScoreboardHud) HudManager.getInstance().get(ScoreboardHud.ID);
		ScoreboardRenderEvent event = new ScoreboardRenderEvent(objective);
		Events.SCOREBOARD_RENDER_EVENT.invoker().accept(event);
		if (event.isCancelled() || hud.isEnabled()) {
			ci.cancel();
		}
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GameGui;hasCrosshair()Z"))
	public boolean axolotlclient$noCrosshair(C_8651652 instance) {
		CrosshairHud hud = (CrosshairHud) HudManager.getInstance().get(CrosshairHud.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			C_3754158.m_0833259(775, 769, 1, 0);
			C_3754158.m_2754767();
			return false;
		}
		return hasCrosshair();
	}

	@Shadow
	protected abstract boolean hasCrosshair();

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;draw(Ljava/lang/String;III)I", ordinal = 0))
	public int axolotlclient$actionBar(C_3831727 instance, String text, int x, int y, int color) {
		ActionBarHud hud = (ActionBarHud) HudManager.getInstance().get(ActionBarHud.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			hud.setActionBar(text, color);
			return 0;
		}
		return instance.m_4683674(text, x, y, color);
	}

	@Inject(method = "renderBossBars", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$customBossBar(CallbackInfo ci) {
		BossBarHud hud = (BossBarHud) HudManager.getInstance().get(BossBarHud.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			ci.cancel();
		}
	}

	@Inject(method = "renderHotbar", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$customHotbar(C_7799337 window, float tickDelta, CallbackInfo ci) {
		HotbarHUD hud = (HotbarHUD) HudManager.getInstance().get(HotbarHUD.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			ci.cancel();
		}
	}

	@ModifyArgs(method = "renderMainHandMessage", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;drawWithShadow(Ljava/lang/String;FFI)I"))
	public void axolotlclient$setItemNamePos(Args args) {
		HotbarHUD hud = (HotbarHUD) HudManager.getInstance().get(HotbarHUD.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			args.set(1, ((Integer) hud.getX()).floatValue() + (hud.getWidth() * hud.getScale()
				- C_8105098.m_0408063().f_0426313.m_0040387(args.get(0))) / 2);
			args.set(2, ((Integer) hud.getY()).floatValue() - 36
				+ (!C_8105098.m_0408063().f_2031079.m_0291543() ? 14 : 0));
		}
	}

	@ModifyArgs(method = "renderJumpBar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GameGui;drawTexture(IIIIII)V"))
	public void axolotlclient$moveHorseHealth(Args args) {
		HotbarHUD hud = (HotbarHUD) HudManager.getInstance().get(HotbarHUD.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			args.set(0, hud.getX());
			args.set(1, hud.getY() - 7);
		}
	}

	@ModifyArgs(method = "renderXpBar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GameGui;drawTexture(IIIIII)V"))
	public void axolotlclient$moveXPBar(Args args) {
		HotbarHUD hud = (HotbarHUD) HudManager.getInstance().get(HotbarHUD.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			args.set(0, hud.getX());
			args.set(1, hud.getY() - 7);
		}
	}

	@Redirect(method = "renderXpBar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/Window;getHeight()I", ordinal = 1))
	public int axolotlclient$moveXPBarHeight(C_7799337 instance) {
		HotbarHUD hud = (HotbarHUD) HudManager.getInstance().get(HotbarHUD.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			return hud.getY() + 22;
		}
		return instance.m_5421693();
	}

	@Redirect(method = "renderXpBar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/Window;getWidth()I"))
	public int axolotlclient$moveXPBarWidth(C_7799337 instance) {
		HotbarHUD hud = (HotbarHUD) HudManager.getInstance().get(HotbarHUD.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			return hud.getX() * 2 + hud.getWidth();
		}
		return instance.m_1713651();
	}

	@Redirect(method = "renderStatusBars", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/Window;getHeight()I"))
	public int axolotlclient$moveStatusBarsHeight(C_7799337 instance) {
		HotbarHUD hud = (HotbarHUD) HudManager.getInstance().get(HotbarHUD.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			return hud.getY() + 22;
		}
		return instance.m_5421693();
	}

	@Redirect(method = "renderStatusBars", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/Window;getWidth()I"))
	public int axolotlclient$moveStatusBarsWidth(C_7799337 instance) {
		HotbarHUD hud = (HotbarHUD) HudManager.getInstance().get(HotbarHUD.ID);
		if (HudManager.getInstance().hudsEnabled() && hud.isEnabled()) {
			return hud.getX() * 2 + hud.getWidth();
		}
		return instance.m_1713651();
	}

	@ModifyVariable(
		method = "renderStatusBars",
		at = @At(
			value = "STORE"
		),
		ordinal = 18
	)
	public int axolotlclient$displayHardcoreHearts(int offset) {
		boolean hardcore = BedwarsMod.getInstance().isEnabled() &&
			BedwarsMod.getInstance().inGame() && BedwarsMod.getInstance().hardcoreHearts.get() &&
			!BedwarsMod.getInstance().getGame().get().getSelf().isBed();
		return hardcore ? 5 : offset;
	}

	@ModifyVariable(
		method = "renderStatusBars",
		at = @At(
			value = "STORE"
		),
		ordinal = 0
	)
	public C_0539808 axolotlclient$dontHunger(C_0539808 normal) {
		if (normal == null && BedwarsMod.getInstance().isEnabled() &&
			BedwarsMod.getInstance().inGame() &&
			!BedwarsMod.getInstance().showHunger.get()) {
			return axolotlclient$noHungerEntityTM;
		}
		return normal;
	}

	@Inject(method = "renderVignette", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$removeVignette(float f, C_7799337 window, CallbackInfo ci) {
		if (AxolotlClient.config().removeVignette.get()) {
			ci.cancel();
		}
	}

	@Unique
	private float titleScale, subtitleScale;

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;scalef(FFF)V", ordinal = 0))
	private void scaleTitle(float f, CallbackInfo ci, @Local(ordinal = 1) int width, @Local(ordinal = 2) int height) {
		if (!AxolotlClient.config().scaleTitles.get()) {
			return;
		}
		C_3754158.m_4552250(titleScale, titleScale, 1);
	}

	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;scalef(FFF)V", ordinal = 1))
	private void scaleSubtitle(float f, CallbackInfo ci, @Local(ordinal = 1) int width, @Local(ordinal = 2) int height) {
		if (!AxolotlClient.config().scaleTitles.get()) {
			return;
		}
		C_3754158.m_4552250(subtitleScale, subtitleScale, 1);
	}

	@Inject(method = "setTitles", at = @At("HEAD"))
	private void calculateScales(String string, String string2, int i, int j, int k, CallbackInfo ci) {
		if (!AxolotlClient.config().scaleTitles.get()) {
			return;
		}
		var client = C_8105098.m_0408063();
		int padding = AxolotlClient.config().titlePadding.get();
		int windowWidth = Util.getWindow().m_1713651() - padding * 8;
		{
			int width = client.f_0426313.m_0040387(string) * 4; // default scale for titles
			if (width > windowWidth) {
				float scale = (float) width / windowWidth;
				titleScale = 1 / scale;
			}
		}
		{
			int width = client.f_0426313.m_0040387(string2) * 2; // default scale for subtitles
			if (width > windowWidth) {
				float scale = (float) width / windowWidth;
				subtitleScale = 1 / scale;
			}
		}
	}
}
