/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.AxolotlClient;
import net.minecraft.unmapped.C_3504190;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_6955767;
import net.minecraft.unmapped.C_8300121;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_6955767.class)
public abstract class ItemEntityRendererMixin {

	@Inject(method = "applyItemBobbing", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;translatef(FFF)V", ordinal = 0), cancellable = true)
	private void axolotlclient$transformItems(C_8300121 itemEntity, double d, double e, double f, float g, C_3504190 bakedModel, CallbackInfoReturnable<Integer> cir, @Local int i) {
		if (AxolotlClient.config().flatItems.get()) {
			C_3754158.m_5322104(d, e + 0.05, f);
			C_3754158.m_8616673(itemEntity.f_0243146, 0, 0, 1);
			C_3754158.m_8616673(90, 1, 0, 0);
			if (!itemEntity.f_4493928) {
				itemEntity.f_0243146 -= 5;
				C_3754158.m_8616673(itemEntity.f_0243146, 1, 1, 1);
			}
			cir.setReturnValue(i);
		}
	}
}
