/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.util.events.impl.KeyBindChangeEvent;
import net.minecraft.unmapped.C_7778778;
import net.minecraft.unmapped.C_8105098;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_7778778.class)
public abstract class KeyBindingMixin {

	@Shadow
	private boolean pressed;
	@Shadow
	private int keyCode;

	@Inject(method = "set", at = @At(value = "FIELD", target = "Lnet/minecraft/client/options/KeyBinding;pressed:Z"))
	private static void axolotlclient$onPress(int keyCode, boolean pressed, CallbackInfo ci, @Local C_7778778 key) {
		if (pressed) {
			// TODO: handle event for unbound keys as well
			Events.KEY_INPUT.invoker().accept(key.br$getBoundKey());
		}
	}

	@Inject(method = "isPressed", at = @At("HEAD"))
	public void axolotlclient$noMovementFixAfterInventory(CallbackInfoReturnable<Boolean> cir) {
		if (this.keyCode == C_8105098.m_0408063().f_9967940.f_7123189.m_6463487()
			|| keyCode == C_8105098.m_0408063().f_9967940.f_9911664.m_6463487()
			|| keyCode == C_8105098.m_0408063().f_9967940.f_6279366.m_6463487()
			|| keyCode == C_8105098.m_0408063().f_9967940.f_2763889.m_6463487()
			|| keyCode == C_8105098.m_0408063().f_9967940.f_7947370.m_6463487()
			|| keyCode == C_8105098.m_0408063().f_9967940.f_2128824.m_6463487()
			|| keyCode == C_8105098.m_0408063().f_9967940.f_4121176.m_6463487()) {
			this.pressed = (keyCode < 0 ? Mouse.isButtonDown(keyCode + 100) : Keyboard.isKeyDown(keyCode)) &&
				(C_8105098.m_0408063().f_0723335 == null);
		}
	}

	@Inject(method = "setKeyCode", at = @At("RETURN"))
	public void axolotlclient$boundKeySet(int code, CallbackInfo ci) {
		io.github.axolotlclient.util.events.Events.KEYBIND_CHANGE.invoker().invoke(new KeyBindChangeEvent(code));
	}
}
