/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_1161898;
import net.minecraft.unmapped.C_3488550;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_6607881;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_6607881.class)
public abstract class LivingEntityMixin extends C_0539808 {

	@Shadow
	public abstract float getHealth();

	@Shadow
	public abstract boolean hasStatusEffect(C_3488550 statusEffect);

	@Shadow
	public int defaultMaxHealth;

	public LivingEntityMixin(C_5553933 world) {
		super(world);
	}

	@Inject(method = "damage", at = @At(value = "HEAD"))
	private void axolotlclient$onDamage(C_1161898 source, float damage, CallbackInfoReturnable<Boolean> ci) {
		if (this.m_4008558(source)) {
			return;
		}
		if (getHealth() <= 0.0F) {
			return;
		} else if (source.m_0344189() && hasStatusEffect(C_3488550.f_0052791)) {
			return;
		}
		if (this.f_2147765 > this.defaultMaxHealth / 2.0F) {
			return;
		}

		// The client doesn't really get any sort of information about why a person is damaged
		// Kinda sucks since that means combos can't be guaranteed (i.e. fall damage, or other person hits)
		// Possible fixes: Could wait for swing animation from a player to be played. Could then track eyes to see if hit, give or take
		// 2 ticks or so? Defintely not perfect tho


		// TODO don't we already have a mixin for this?
		/*
		if (source.getAttacker() instanceof PlayerEntity) {
			ComboHud comboHud = (ComboHud) HudManager.getInstance().get(ComboHud.ID);
			comboHud.onEntityDamage(this);
		}

		// 2 ticks or so? Definitely not perfect tho
		if (source.getAttacker() instanceof PlayerEntity) {
			ComboHud comboHud = (ComboHud) HudManager.getInstance().get(ComboHud.ID);
			if (comboHud != null) {
				comboHud.onEntityDamage(this);
			}
		}
		*/
	}
}
