/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.freelook.Perspective;
import io.github.axolotlclient.modules.hud.gui.hud.PlayerHud;
import io.github.axolotlclient.modules.hypixel.NickHider;
import net.minecraft.unmapped.C_3362006;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_6607881;
import net.minecraft.unmapped.C_7106153;
import net.minecraft.unmapped.C_7639596;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8980628;
import net.minecraft.unmapped.C_9550253;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_7639596.class)
public abstract class LivingEntityRendererMixin<T extends C_6607881> extends C_8980628<T> {

	protected LivingEntityRendererMixin(C_3362006 entityRenderDispatcher) {
		super(entityRenderDispatcher);
	}

	@Inject(method = "renderNameTag(Lnet/minecraft/entity/living/LivingEntity;DDD)V", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;rotatef(FFFF)V", ordinal = 1))
	private void axolotlclient$correctNameplateRotation(C_6607881 livingEntity, double d, double e, double f, CallbackInfo ci) {
		if (C_8105098.m_0408063().f_9967940.f_3094045 == Perspective.THIRD_PERSON_FRONT.ordinal()) {
			C_3754158.m_8616673(-this.f_2673078.f_2592027 * 2, 1.0F, 0.0F, 0.0F);
		}
	}

	@Inject(method = "shouldRenderNameTag(Lnet/minecraft/entity/living/LivingEntity;)Z", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$showOwnNametag(C_6607881 livingEntity, CallbackInfoReturnable<Boolean> cir) {
		if (AxolotlClient.config().showOwnNametag.get()
			&& livingEntity.m_3843079() == C_8105098.m_0408063().f_7663840.m_3843079()
			&& !PlayerHud.isCurrentlyRendering()) {
			cir.setReturnValue(true);
		}
	}

	@WrapOperation(method = "renderNameTag(Lnet/minecraft/entity/living/LivingEntity;DDD)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/living/LivingEntity;getDisplayName()Lnet/minecraft/text/Text;"))
	public C_9550253 axolotlclient$hideNameWhenSneaking(C_6607881 instance, Operation<C_9550253> original) {
		var orig = original.call(instance);
		if (instance instanceof C_7106153) {
			if (NickHider.getInstance().hideOwnName.get() && instance.equals(C_8105098.m_0408063().f_7663840)) {
				orig = (C_9550253) NickHider.getInstance().editComponent(orig, instance.m_6689989(), NickHider.getInstance().hiddenNameSelf.get());
			} else if (NickHider.getInstance().hideOtherNames.get()
				&& !instance.equals(C_8105098.m_0408063().f_7663840)) {
				orig = (C_9550253) NickHider.getInstance().editComponent(orig, instance.m_6689989(), NickHider.getInstance().hiddenNameOthers.get());
			}
		}
		return orig;
	}

	@ModifyConstant(method = "setupOverlayColor(Lnet/minecraft/entity/living/LivingEntity;FZ)Z", constant = @Constant(floatValue = 1.0f, ordinal = 0))
	private float axolotlclient$customHitColorRed(float constant) {
		return AxolotlClient.config().hitColor.get().getRed() / 255F;
	}

	@ModifyConstant(method = "setupOverlayColor(Lnet/minecraft/entity/living/LivingEntity;FZ)Z", constant = @Constant(floatValue = 0.0f, ordinal = 0))
	private float axolotlclient$customHitColorGreen(float constant) {
		return AxolotlClient.config().hitColor.get().getGreen() / 255F;
	}

	@ModifyConstant(method = "setupOverlayColor(Lnet/minecraft/entity/living/LivingEntity;FZ)Z", constant = @Constant(floatValue = 0.0f, ordinal = 1))
	private float axolotlclient$customHitColorBlue(float constant) {
		return AxolotlClient.config().hitColor.get().getBlue() / 255F;
	}

	@ModifyConstant(method = "setupOverlayColor(Lnet/minecraft/entity/living/LivingEntity;FZ)Z", constant = @Constant(floatValue = 0.3f, ordinal = 0))
	private float axolotlclient$customHitColorAlpha(float constant) {
		return AxolotlClient.config().hitColor.get().getAlpha() / 255F;
	}
}
