/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.bridge.entity.AxoPlayer;
import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsMod;
import io.github.axolotlclient.modules.particles.Particles;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_1161898;
import net.minecraft.unmapped.C_3628668;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_4701530;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9590849;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_9590849.class)
public abstract class PlayerEntityMixin extends C_0539808 {

	public PlayerEntityMixin(C_5553933 world) {
		super(world);
	}

	@Inject(method = "attack", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/living/player/PlayerEntity;getAttribute(Lnet/minecraft/entity/living/attribute/EntityAttribute;)Lnet/minecraft/entity/living/attribute/EntityAttributeInstance;"))
	public void axolotlclient$getReach(C_0539808 entity, CallbackInfo ci) {
		Events.PLAYER_ATTACK.invoker().accept((AxoPlayer) this, entity);
	}

	@Inject(method = "attack", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/living/player/PlayerEntity;setAttackTarget(Lnet/minecraft/entity/Entity;)V"))
	public void axolotlclient$alwaysCrit(C_0539808 entity, CallbackInfo ci, @Local(ordinal = 0) boolean bl, @Local(ordinal = 1) float g) {
		if (Particles.getInstance().getAlwaysOn(C_4701530.f_9917373) && !bl) {
			C_8105098.m_0408063().f_7663840.m_9825787(entity);
		}
		if (Particles.getInstance().getAlwaysOn(C_4701530.f_5110895) && !(g > 0)) {
			C_8105098.m_0408063().f_7663840.m_7595504(entity);
		}
	}

	@Inject(method = "damage", at = @At("HEAD"))
	public void axolotlclient$damage(C_1161898 source, float amount, CallbackInfoReturnable<Boolean> cir) {
		Events.PLAYER_HURT.invoker().accept((AxoPlayer) this, source.m_6738043());
	}

	@Inject(
		method = "getArmorProtection",
		at = @At(
			"HEAD"
		),
		cancellable = true
	)
	public void axolotlclient$disableArmor(CallbackInfoReturnable<Integer> ci) {
		if (BedwarsMod.getInstance().isEnabled() && BedwarsMod.getInstance().inGame() && !BedwarsMod.getInstance().displayArmor.get()) {
			ci.setReturnValue(0);
		}
	}

	@Inject(method = "trySleep", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/BlockState;"), cancellable = true)
	private void removeErrorOnAirBlock(C_3674802 blockPos, CallbackInfoReturnable<C_9590849.C_3716622> cir) {
		if (f_4703454.m_4919395(blockPos).m_0999604().m_9214095(C_3628668.f_3097723)) {
			cir.setReturnValue(C_9590849.C_3716622.f_2809257);
		}
	}
}
