/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.mojang.authlib.GameProfile;
import io.github.axolotlclient.modules.hypixel.NickHider;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3543146;
import net.minecraft.unmapped.C_5946149;
import net.minecraft.unmapped.C_8105098;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_3543146.class)
public abstract class PlayerListEntryMixin {

	@Shadow
	@Final
	private GameProfile profile;

	@Inject(method = "getSkinTexture", at = @At("RETURN"), cancellable = true)
	public void axolotlclient$hideSkins(CallbackInfoReturnable<C_0561170> cir) {
		if (profile.equals(C_8105098.m_0408063().f_7663840.m_2101945())
			&& NickHider.getInstance().hideOwnSkin.get()) {
			cir.setReturnValue(C_5946149.m_2817663(profile.getId()));
		} else if (!profile.equals(C_8105098.m_0408063().f_7663840.m_2101945())
			&& NickHider.getInstance().hideOtherSkins.get()) {
			cir.setReturnValue(C_5946149.m_2817663(profile.getId()));
		}
	}
}
