/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.unmapped.C_0814381;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3543146;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_3945557;
import net.minecraft.unmapped.C_4052762;
import net.minecraft.unmapped.C_4354908;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9550253;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.bridge.impl.AxoRenderContextImpl;
import io.github.axolotlclient.modules.hypixel.NickHider;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsGame;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsMod;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsPlayer;
import io.github.axolotlclient.modules.tablist.Tablist;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_4052762.class)
public abstract class PlayerListHudMixin extends C_2691939 {
	@Unique
	private final C_8105098 axolotlclient$client = C_8105098.m_0408063();
	@Shadow
	private C_9550253 header;
	@Shadow
	private C_9550253 footer;

	@Shadow
	@Final
	private C_8105098 minecraft;

	@Inject(method = "getDisplayName", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$nickHider(C_3543146 playerEntry, CallbackInfoReturnable<String> cir) {
		if (playerEntry.m_3450020().getId() == C_8105098.m_0408063().f_7663840.m_2013188()
			&& NickHider.getInstance().hideOwnName.get()) {
			cir.setReturnValue(NickHider.getInstance().hiddenNameSelf.get());
		} else if (playerEntry.m_3450020().getId() != C_8105098.m_0408063().f_7663840.m_2013188()
			&& NickHider.getInstance().hideOtherNames.get()) {
			cir.setReturnValue(NickHider.getInstance().hiddenNameOthers.get());
		}
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;getWidth(Ljava/lang/String;)I", ordinal = 0))
	private int axolotlclient$moveName(C_3831727 instance, String string, Operation<Integer> original, @Local C_3543146 entry) {
		var width = original.call(instance, string);
		if (AxolotlClient.config().showBadges.get() && UserRequest.getOnline(entry.m_3450020().getId().toString())) {
			width += 10;
		}
		if (Tablist.getInstance().numericalPing.get())
			width += (instance.m_0040387(String.valueOf(entry.m_7717663())) - 10);
		return width;
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;drawWithShadow(Ljava/lang/String;FFI)I", ordinal = 1))
	public int axolotlclient$moveName2(C_3831727 instance, String string, float x, float y, int color, Operation<Integer> original, @Local GameProfile entry) {
		if (AxolotlClient.config().showBadges.get() && UserRequest.getOnline(entry.getId().toString())) {
			axolotlclient$client.m_1218956().m_5325521(AxolotlClient.badgeIcon);
			C_2691939.m_5935491((int) x, (int) y, 0, 0, 8, 8, 8, 8);
			x += 10;
		}
		return original.call(instance, string, x, y, color);
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;drawWithShadow(Ljava/lang/String;FFI)I", ordinal = 2))
	public int axolotlclient$moveName3(C_3831727 instance, String string, float x, float y, int color, Operation<Integer> original, @Local GameProfile entry) {
		return axolotlclient$moveName2(instance, string, x, y, color, original, entry);
	}

	@Inject(method = "renderPing", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$numericalPing(int width, int x, int y, C_3543146 entry, CallbackInfo ci) {
		if (BedwarsMod.getInstance().isEnabled() && BedwarsMod.getInstance().blockLatencyIcon() && (BedwarsMod.getInstance().isWaiting() || BedwarsMod.getInstance().inGame())) {
			ci.cancel();
		} else if (Tablist.getInstance().renderNumericPing(width, x, y, entry)) {
			ci.cancel();
		}
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/Minecraft;isIntegratedServerRunning()Z"))
	private boolean axolotlclient$showPlayerHeads$1(C_8105098 instance) {
		if (Tablist.getInstance().showPlayerHeads.get()) {
			return instance.m_3844208();
		}
		return false;
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/Connection;isEncrypted()Z"))
	private boolean axolotlclient$showPlayerHeads$2(C_4354908 instance) {
		if (Tablist.getInstance().showPlayerHeads.get()) {
			return instance.m_5134944();
		}
		return false;
	}

	@Inject(method = "render", at = @At(value = "FIELD", target = "Lnet/minecraft/client/gui/overlay/PlayerTabOverlay;header:Lnet/minecraft/text/Text;"))
	private void axolotlclient$setRenderHeaderFooter(int width, C_0814381 scoreboard, C_3945557 playerListScoreboardObjective, CallbackInfo ci) {
		if (!Tablist.getInstance().showHeader.get()) {
			header = null;
		}
		if (!Tablist.getInstance().showFooter.get()) {
			footer = null;
		}
	}

	@ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/world/ClientWorld;getPlayer(Ljava/util/UUID;)Lnet/minecraft/entity/living/player/PlayerEntity;"))
	private UUID axolotlclient$makeStuff(UUID par1) {
		return Tablist.getInstance().alwaysShowHeadLayer.get() ? C_8105098.m_0408063().f_7663840.m_2013188() : par1;
	}

	@Inject(
		method = "renderDisplayScore",
		at = @At(
			value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;drawWithShadow(Ljava/lang/String;FFI)I", ordinal = 1
		),
		cancellable = true
	)
	public void axolotlclient$renderCustomScoreboardObjective(
		C_3945557 objective, int y, String player, int startX, int endX, C_3543146 playerEntry, CallbackInfo ci
	) {
		if (!BedwarsMod.getInstance().isEnabled()) {
			return;
		}

		BedwarsGame game = BedwarsMod.getInstance().getGame().orElse(null);
		if (game == null) {
			return;
		}

		game.renderCustomScoreboardObjective(
			AxoRenderContextImpl.getInstance(), playerEntry.m_3450020().getName(),
			objective.m_2944653().m_4288528(player, objective).m_7979602(), y, endX);
		ci.cancel();


	}

	@ModifyVariable(
		method = "render",
		at = @At(
			value = "STORE"
		),
		ordinal = 7
	)
	public int axolotlclient$changeWidth(int value) {
		if (BedwarsMod.getInstance().isEnabled() && BedwarsMod.getInstance().blockLatencyIcon() && (BedwarsMod.getInstance().isWaiting() || BedwarsMod.getInstance().inGame())) {
			value -= 9;
		}
		if (BedwarsMod.getInstance().isEnabled() && BedwarsMod.getInstance().isWaiting()) {
			value += 20;
		}
		return value;
	}

	@Inject(method = "getDisplayName", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$getPlayerName(C_3543146 playerEntry, CallbackInfoReturnable<String> cir) {
		if (!BedwarsMod.getInstance().isEnabled()) {
			return;
		}
		BedwarsGame game = BedwarsMod.getInstance().getGame().orElse(null);
		if (game == null || !game.isStarted()) {
			return;
		}
		BedwarsPlayer player = game.getPlayer(playerEntry.m_3450020().getName()).orElse(null);
		if (player == null) {
			return;
		}
		cir.setReturnValue(player.getTabListDisplay());
	}

	@SuppressWarnings("unchecked")
	@ModifyVariable(method = "render", at = @At(value = "INVOKE_ASSIGN", target = "Lcom/google/common/collect/Ordering;sortedCopy(Ljava/lang/Iterable;)Ljava/util/List;", remap = false))
	public List<C_3543146> axolotlclient$overrideSortedPlayers(List<C_3543146> original) {
		if (!BedwarsMod.getInstance().inGame()) {
			return original;
		}
		List<? super C_3543146> players = BedwarsMod.getInstance().getGame().orElseThrow().getTabPlayerList(Collections.unmodifiableList(original));
		if (players == null) {
			return original;
		}
		return (List<C_3543146>) players;
	}

	@Inject(method = "setHeader", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$changeHeader(C_9550253 header, CallbackInfo ci) {
		if (!BedwarsMod.getInstance().inGame()) {
			return;
		}
		this.header = (C_9550253) BedwarsMod.getInstance().getGame().orElseThrow().getTopBarText();
		ci.cancel();
	}

	@Inject(method = "setFooter", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$changeFooter(C_9550253 footer, CallbackInfo ci) {
		if (!BedwarsMod.getInstance().inGame()) {
			return;
		}
		this.footer = (C_9550253) BedwarsMod.getInstance().getGame().orElseThrow().getBottomBarText();
		ci.cancel();
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/overlay/PlayerTabOverlay;fill(IIIII)V"), slice = @Slice(to = @At(value = "CONSTANT", args = "intValue=553648127")))
	private void modifyBackground(int x1, int y1, int x2, int y2, int color, Operation<Void> original) {
		var tablist = Tablist.getInstance();
		if (!tablist.backgroundEnabled.get()) {
			return;
		}
		if (tablist.customBackgroundColor.get()) {
			original.call(x1, y1, x2, y2, tablist.backgroundColor.get().toInt());
			return;
		}
		original.call(x1, y1, x2, y2, color);
	}

	@WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/overlay/PlayerTabOverlay;fill(IIIII)V"), slice = @Slice(from = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/overlay/PlayerTabOverlay;renderPing(IIILnet/minecraft/client/network/PlayerInfo;)V")))
	private void modifyBackground$2(int x1, int y1, int x2, int y2, int color, Operation<Void> original) {
		modifyBackground(x1, y1, x2, y2, color, original);
	}
}
