/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.unmapped.C_1716360;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2848808;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_9550253;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_2848808.class)
public abstract class TextRenderUtilsMixin {

	@Unique
	private static final Map<Character, C_1945050> formattingCodes;

	static {
		var map = new Object2ObjectOpenHashMap<Character, C_1945050>();
		map.put('0', C_1945050.f_2113304);
		map.put('1', C_1945050.f_2702167);
		map.put('2', C_1945050.f_1377263);
		map.put('3', C_1945050.f_2296475);
		map.put('4', C_1945050.f_3447522);
		map.put('5', C_1945050.f_8162691);
		map.put('6', C_1945050.f_0313642);
		map.put('7', C_1945050.f_7540461);
		map.put('8', C_1945050.f_2985643);
		map.put('9', C_1945050.f_7743109);
		map.put('a', C_1945050.f_7735202);
		map.put('b', C_1945050.f_0440484);
		map.put('c', C_1945050.f_9213701);
		map.put('d', C_1945050.f_3614776);
		map.put('e', C_1945050.f_6222183);
		map.put('f', C_1945050.f_5887713);
		map.put('k', C_1945050.f_2867603);
		map.put('l', C_1945050.f_7940829);
		map.put('m', C_1945050.f_3018816);
		map.put('n', C_1945050.f_0689059);
		map.put('o', C_1945050.f_8012292);
		map.put('r', C_1945050.f_1149207);
		formattingCodes = map;
	}


	@Inject(method = "wrapText", at = @At("HEAD"))
	private static void reformatText(C_9550253 pText, int i, C_3831727 textRenderer, boolean bl, boolean bl2, CallbackInfoReturnable<List<C_9550253>> cir, @Local(argsOnly = true) LocalRef<C_9550253> text) {
		text.set(format(text.get()));
	}

	@Unique
	private static C_1945050 byCodeOfFirstChar(String code) {
		char c = code.toLowerCase(Locale.ROOT).charAt(0);

		for (Map.Entry<Character, C_1945050> formatting : formattingCodes.entrySet()) {
			if (formatting.getKey() == c) {
				return formatting.getValue();
			}
		}

		return null;
	}

	@Unique
	private static final Pattern CODE_PATTERN = Pattern.compile("§");

	@Unique
	private static C_9550253 format(C_9550253 text) {
		C_9550253 n = null;
		for (var t : text) {
			if (!t.m_5549412().contains("§")) {
				var r = new C_1716360(t.m_5549412());
				r.m_7551367(t.m_9212619());
				if (n == null) {
					n = r;
				} else {
					n.m_8059675(r);
					t.m_9212619().m_8804244(n.m_9212619());
				}
			} else {
				var formatted = formatFromCodes(t.m_5549412());
				formatted.m_7551367(t.m_9212619());
				if (n == null) {
					n = formatted;
				} else {
					n.m_8059675(formatted);
					formatted.m_9212619().m_8804244(n.m_9212619());
				}
			}
		}
		return n;
	}

	@Unique
	private static C_9550253 formatFromCodes(String formattedString) {
		C_9550253 text = new C_1716360("");
		String[] arr = CODE_PATTERN.split(formattedString);

		List<C_1945050> modifiers = new ArrayList<>();
		C_1945050 color = null;
		Integer br$color = null;
		for (int i = 0, length = arr.length; i < length; i++) {
			String s = arr[i];
			if (s.isEmpty()) {
				continue;
			} else if (i == 0) {
				text.m_1643573(s);
				continue;
			}
			C_1945050 formatting = byCodeOfFirstChar(s);
			C_9550253 part;
			int pL = s.length();
			int formatLength = 1;
			if (formatting == null) {
				if (s.toLowerCase(Locale.ROOT).charAt(0) == '#') {
					br$color = Color.parse(s.substring(0, 7)).toInt();
					formatLength = 7;
				} else {
					text.m_1643573(s);
					continue;
				}
			} else {
				if (formatting.equals(C_1945050.f_1149207)) {
					modifiers.clear();
					color = null;
				} else if (formatting.m_4451753()) {
					modifiers.add(formatting);
				} else {
					color = formatting;
				}
			}
			if (pL == 1) {
				continue;
			}
			part = new C_1716360(s.substring(formatLength));

			if (color != null) {
				part.m_7551367(part.m_9212619().m_0282611(color));
			}
			if (br$color != null) {
				part.br$setStyle(part.m_9212619().br$color(br$color));
			}

			if (!modifiers.isEmpty()) {
				for (C_1945050 mod : modifiers) {
					switch (mod) {
						case f_2867603 -> part.m_9212619().m_9003578(true);
						case f_7940829 -> part.m_9212619().m_5934684(true);
						case f_8012292 -> part.m_9212619().m_6301017(true);
						case f_0689059 -> part.m_9212619().m_9739860(true);
						case f_3018816 -> part.m_9212619().m_1650025(true);
						default -> AxolotlClient.LOGGER.warn("Unexpected modifier: " + mod);
					}
				}
			}
			text.m_8059675(part);
		}
		return text;
	}
}
