/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_4461663;
import net.minecraft.unmapped.C_5786166;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8373595;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(C_3831727.class)
public abstract class TextRendererMixin {

	// Pain at its finest

	@Unique
	private final C_0561170 texture_g = new C_0561170("axolotlclient", "textures/font/g_breve_capital.png");
	@Shadow
	public int fontHeight;
	@Shadow
	private float r;
	@Shadow
	private float g;
	@Shadow
	private float b;
	@Shadow
	private float a;
	@Shadow
	private float x;
	@Shadow
	private float y;
	@Shadow
	private int color;
	@Unique
	private boolean shouldHaveShadow;

	@Inject(method = "drawLayer(Ljava/lang/String;FFIZ)I", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;drawLayer(Ljava/lang/String;Z)V"))
	public void axolotlclient$getData(String text, float x, float y, int color, boolean shadow, CallbackInfoReturnable<Integer> cir) {
		if (text != null) {
			shouldHaveShadow = shadow;
		}
	}

	@Inject(method = "drawGlyph", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$gBreve(char c, boolean bl, CallbackInfoReturnable<Float> cir) {
		if (c == 'Ğ' && !C_8105098.m_0408063().f_9967940.f_6565278) {
			C_8105098.m_0408063().m_1218956().m_5325521(texture_g);

			if (!bl || shouldHaveShadow) {
				C_3754158.m_3323122(this.r / 4, this.g / 4, this.b / 4, this.a);
				drawTexture(this.x + 1, this.y - this.fontHeight + 7);
			}

			C_3754158.m_3323122(this.r, this.g, this.b, this.a);
			drawTexture(this.x, this.y - this.fontHeight + 6);

			C_3754158.m_3323122(this.r, this.g, this.b, this.a);
			cir.setReturnValue(7.0F);
		}
	}

	@Unique
	private void drawTexture(float x, float y) {
		C_5786166 tessellator = C_5786166.m_2065116();
		C_8373595 bufferBuilder = tessellator.m_1454391();
		bufferBuilder.m_0421390(7, C_4461663.f_9223614);
		bufferBuilder.m_3299851(x, y + 10, 0.0).m_4749889(0, 1).m_4365807();
		bufferBuilder.m_3299851((x + 5), (y + 10), 0.0).m_4749889(1, 1).m_4365807();
		bufferBuilder.m_3299851((x + 5), y, 0.0).m_4749889(1, 0).m_4365807();
		bufferBuilder.m_3299851(x, y, 0.0).m_4749889(0, 0).m_4365807();
		tessellator.m_8222644();
	}

	@Inject(method = "getWidth(C)I", at = @At(value = "HEAD"), cancellable = true)
	public void axolotlclient$modifiedCharWidth(char c, CallbackInfoReturnable<Integer> cir) {
		if (c == 'Ğ' && !C_8105098.m_0408063().f_9967940.f_6565278) {
			cir.setReturnValue(7);
		}
	}

	@Unique
	private static final Pattern COLOR_PATTERN = Pattern.compile("(#(?:0x)?[a-fA-F0-9]{6})");

	// This target does not exist when using OptiFine
	@WrapOperation(method = "drawLayer(Ljava/lang/String;Z)V", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;color4f(FFFF)V", ordinal = 0), require = 0)
	private void customFormattingCode(float red, float green, float blue, float alpha, Operation<Void> original, String string, boolean bl, @Local(ordinal = 0) LocalIntRef index) {
		if (index.get() + 7 < string.length() && string.charAt(index.get() + 1) == '#') {

			String color = string.substring(index.get() + 1).toLowerCase(Locale.ROOT);
			var matcher = COLOR_PATTERN.matcher(color).region(0, Math.min(10, color.length()));
			if (!matcher.find()) {
				return;
			}
			Color parsed = Color.parse(matcher.group(1));
			int c = parsed.toInt();
			if (bl) {
				c = (c & 0xFCFCFC) >> 2 | c & 0xFF000000;
			}
			red = (float) (c >> 16 & 0xFF) / 255.0F;
			green = (float) (c >> 8 & 0xFF) / 255.0F;
			blue = (float) (c & 0xFF) / 255.0F;
			this.color = c;
			index.set(index.get() + matcher.end(1) - 1);
		}
		original.call(red, green, blue, alpha);
	}

	// This target only exists with OptiFine
	@WrapOperation(method = "drawLayer(Ljava/lang/String;Z)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;setColor(FFFF)V"), require = 0)
	private void customFormattingCode$OF(C_3831727 renderer, float red, float green, float blue, float alpha, Operation<Void> original, String string, boolean bl, @Local(ordinal = 0) LocalIntRef index) {
		if (index.get() + 7 < string.length() && string.charAt(index.get() + 1) == '#') {

			String color = string.substring(index.get() + 1).toLowerCase(Locale.ROOT);
			var matcher = COLOR_PATTERN.matcher(color).region(0, Math.min(10, color.length()));
			if (!matcher.find()) {
				return;
			}
			Color parsed = Color.parse(matcher.group(1));
			int c = parsed.toInt();
			if (bl) {
				c = (c & 0xFCFCFC) >> 2 | c & 0xFF000000;
			}
			red = (float) (c >> 16 & 0xFF) / 255.0F;
			green = (float) (c >> 8 & 0xFF) / 255.0F;
			blue = (float) (c & 0xFF) / 255.0F;
			this.color = c;
			index.set(index.get() + matcher.end(1) - 1);
		}
		original.call(renderer, red, green, blue, alpha);
	}

	// Again, the first target is for vanilla, the second for OptiFine.
	@WrapOperation(method = "getWidth(Ljava/lang/String;)I", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;getWidth(C)I"), require = 0)
	private int customFormattingCodeWidth(C_3831727 instance, char c, Operation<Integer> original, String string, @Local(ordinal = 1) LocalIntRef index) {
		if (index.get() + 7 < string.length() && string.charAt(index.get() + 1) == '#') {

			String color = string.substring(index.get() + 1).toLowerCase(Locale.ROOT);
			var matcher = COLOR_PATTERN.matcher(color).region(0, Math.min(10, color.length()));
			if (!matcher.find()) {
				return original.call(instance, c);
			}
			index.set(index.get() + matcher.end(1));
			return 0;
		}
		return original.call(instance, c);
	}

	@WrapOperation(method = "getWidth(Ljava/lang/String;)I", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/TextRenderer;getCharWidthFloat(C)F"), require = 0)
	private float customFormattingCodeWidth$OF(C_3831727 instance, char c, Operation<Float> original, String string, @Local(ordinal = 0) LocalIntRef index) {
		if (index.get() + 7 < string.length() && string.charAt(index.get() + 1) == '#') {

			String color = string.substring(index.get() + 1).toLowerCase(Locale.ROOT);
			var matcher = COLOR_PATTERN.matcher(color).region(0, Math.min(10, color.length()));
			if (!matcher.find()) {
				return original.call(instance, c);
			}
			index.set(index.get() + matcher.end(1));
			return 0;
		}
		return original.call(instance, c);
	}
}
