/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfigCommon;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.APIOptions;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.NewsScreen;
import io.github.axolotlclient.api.chat.ChatListScreen;
import io.github.axolotlclient.api.requests.GlobalDataRequest;
import io.github.axolotlclient.modules.auth.AccountsScreen;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.auth.AuthWidget;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.util.OSUtil;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8938952;
import net.minecraft.unmapped.C_9468736;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(C_8938952.class)
public abstract class TitleScreenMixin extends C_3020744 {

	@Shadow
	public abstract void m_7261014(int par1, int par2, float par3);

	@Shadow
	private boolean f_2867010;

	@Inject(method = "initWidgetsNormal", at = @At("TAIL"))
	private void axolotlclient$replaceRealmsButton(int i, int j, CallbackInfo ci) {
		List<C_2348249> buttons = new ArrayList<>();
		int leftButtonY = 10;
		if (Auth.getInstance().showButton.get()) {
			buttons.add(new AuthWidget(10, leftButtonY));
			leftButtonY += 25;
		}
		this.f_2213969.addAll(buttons);
		if (APIOptions.getInstance().addShortcutButtons.get()) {
			int y = leftButtonY;
			Runnable addApiButtons = () -> {
				C_2348249 friends = new C_2348249(142, 10, y, 50, 20, C_3390001.m_2053009("api.friends"));
				this.f_2213969.add(friends);
				buttons.add(friends);
				C_2348249 chats = new C_2348249(42, 10, y + 25, 50, 20, C_3390001.m_2053009("api.chats"));
				this.f_2213969.add(chats);
				buttons.add(chats);
			};
			if (API.getInstance().isSocketConnected()) {
				addApiButtons.run();
			} else {
				API.addStartupListener(() -> f_7153641.m_2167033(addApiButtons), API.ListenerType.ONCE);
			}
		}
		GlobalDataRequest.get().thenAccept(data -> {
			int buttonY = 10;
			if (APIOptions.getInstance().updateNotifications.get() &&
				data.success() &&
				data.latestVersion().isNewerThan(AxolotlClient.VERSION)) {
				C_2348249 newVersion = new C_2348249(182, f_5465691 - 90, buttonY, 80, 20, C_3390001.m_2053009("api.new_version_available"));
				this.f_2213969.add(newVersion);
				buttons.add(newVersion);
				buttonY += 22;
			}
			if (APIOptions.getInstance().displayNotes.get() &&
				data.success() && !data.notes().isEmpty()) {
				C_2348249 notes = new C_2348249(253, f_5465691 - 90, buttonY, 80, 20,
					C_3390001.m_2053009("api.notes"));
				this.f_2213969.add(notes);
				buttons.add(notes);
			}
		});

		if (FabricLoader.getInstance().isModLoaded("modmenu")) {
			try {
				Class<?> booleanConfigOpt = MethodHandles.lookup().findClass("com.terraformersmc.modmenu.config.option.BooleanConfigOption");
				Class<?> enumConfigOpt = MethodHandles.lookup().findClass("com.terraformersmc.modmenu.config.option.EnumConfigOption");
				Class<?> titleMenuButtonStyle = MethodHandles.lookup().findClass("com.terraformersmc.modmenu.config.ModMenuConfig$TitleMenuButtonStyle");
				Class<?> modmenuConfig = MethodHandles.lookup().findClass("com.terraformersmc.modmenu.config.ModMenuConfig");
				MethodHandle modifyTitleScreenHandle = MethodHandles.lookup().findStaticGetter(modmenuConfig, "MODIFY_TITLE_SCREEN", booleanConfigOpt);
				MethodHandle getValueB = MethodHandles.lookup().findVirtual(booleanConfigOpt, "getValue", MethodType.methodType(boolean.class));
				MethodHandle getValueE = MethodHandles.lookup().findVirtual(enumConfigOpt, "getValue", MethodType.methodType(Enum.class));
				var modifyTitleScreen = modifyTitleScreenHandle.invoke();
				boolean isModifyTitleScreen = (boolean) getValueB.invoke(modifyTitleScreen);
				MethodHandle modsButtonStyleHandle = MethodHandles.lookup().findStaticGetter(modmenuConfig, "MODS_BUTTON_STYLE", enumConfigOpt);
				var modsButtonStyle = getValueE.invoke(modsButtonStyleHandle.invoke());
				var classic = titleMenuButtonStyle.getEnumConstants()[0];
				if (isModifyTitleScreen && modsButtonStyle == classic) {
					buttons.forEach(r -> r.f_8532347 -= 24 / 2);
				}
			} catch (Throwable ignored) {
			}
		}
	}

	@Inject(method = "initWidgetsNormal", at = @At("TAIL"))
	private void axolotlclient$addOptionsButton(int y, int spacingY, CallbackInfo ci) {
		if (AxolotlClientConfigCommon.instance().titleScreenOptionButtonMode.get().showButton()) {
			f_2213969.add(new C_2348249(192, this.f_5465691 / 2 - 100, y + spacingY * 3, C_3390001.m_2053009("config") + "..."));
		}
	}

	@ModifyConstant(method = "init", constant = @Constant(intValue = 72))
	private int axolotlclient$moveButtons(int constant) {
		if (AxolotlClientConfigCommon.instance().titleScreenOptionButtonMode.get().showButton()) {
			return constant + 25;
		}
		return constant;
	}

	@Inject(method = "buttonClicked", at = @At("TAIL"))
	public void axolotlclient$onClick(C_2348249 button, CallbackInfo ci) {
		if (button.f_5920996 == 192)
			C_8105098.m_0408063().m_6408915(new HudEditScreen(this));
		else if (button.f_5920996 == 242)
			C_8105098.m_0408063().m_6408915(new AccountsScreen(C_8105098.m_0408063().f_0723335));
		else if (button.f_5920996 == 182)
			C_8105098.m_0408063().m_6408915(new C_9468736((bl, i) -> {
				if (bl && i == 353) {
					OSUtil.getOS().open(URI.create("https://modrinth.com/mod/axolotlclient/versions"));
				}
				C_8105098.m_0408063().m_6408915(this);
			}, "https://modrinth.com/mod/axolotlclient/versions", 353, true));
		else if (button.f_5920996 == 253)
			C_8105098.m_0408063().m_6408915(new NewsScreen(this));
		else if (button.f_5920996 == 142) f_7153641.m_6408915(new FriendsScreen(this));
		else if (button.f_5920996 == 42) f_7153641.m_6408915(new ChatListScreen(this));
	}

	@Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/TitleScreen;drawString(Lnet/minecraft/client/render/TextRenderer;Ljava/lang/String;III)V", ordinal = 0))
	public void axolotlclient$customBranding(C_8938952 instance, C_3831727 textRenderer, String s, int x, int y, int color) {
		if (FabricLoader.getInstance().getModContainer("axolotlclient").isPresent()) {
			instance.m_6649515(textRenderer,
				"Minecraft 1.8.9/" + ClientBrandRetriever.getClientModName() + " " + AxolotlClient.VERSION,
				x, y, color);
		} else {
			instance.m_6649515(textRenderer, s, x, y, color);
		}
	}

	@Inject(method = "<init>",
		at = @At(value = "INVOKE",
			target = "Ljava/io/BufferedReader;readLine()Ljava/lang/String;", remap = false))
	private void axolotlclient$customSplashTexts(CallbackInfo ci, @Local List<String> list) throws IOException {
		try (InputStream input = C_8105098.m_0408063().m_3739907()
			.m_5942034(new C_0561170("axolotlclient", "texts/splashes.txt")).m_3098790()) {
			list.addAll(IOUtils.readLines(input));
		}
	}

	@Inject(method = "<init>", at = @At("TAIL"))
	private void disableRealms(CallbackInfo ci) {
		this.f_2867010 = true;
	}
}
