/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.sky.SkyboxManager;
import net.minecraft.unmapped.C_3198459;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_7794883;
import net.minecraft.unmapped.C_7873567;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8398976;
import net.minecraft.unmapped.C_9590849;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * This implementation of custom skies is based on the FabricSkyBoxes mod by AMereBagatelle
 * <a href="https://github.com/AMereBagatelle/FabricSkyBoxes">Github Link.</a>
 *
 * <p>License: MIT</p>
 **/

@Mixin(C_8398976.class)
public abstract class WorldRendererMixin {

	@Shadow
	private C_7873567 world;

	@Shadow
	@Final
	private C_8105098 minecraft;

	@Inject(method = "renderSky", at = @At("HEAD"), cancellable = true)
	public void axolotlclient$renderCustomSky(float tickDelta, int anaglyphFilter, CallbackInfo ci) {
		if (this.world.f_6669533.m_4324221()) {
			if (AxolotlClient.config().customSky.get() && SkyboxManager.getInstance().hasSkyBoxes()) {
				C_3754158.m_7643110(false);
				this.minecraft.f_3960058.m_8238460("Custom Skies");
				SkyboxManager.getInstance().renderSkyboxes(tickDelta, world.m_3371074(tickDelta));
				this.minecraft.f_3960058.m_8388219();
				C_3754158.m_7643110(true);
				ci.cancel();
			}
		}
	}

	@Redirect(method = "renderClouds", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/dimension/Dimension;getCloudHeight()F"))
	public float axolotlclient$getCloudHeight(C_3198459 instance) {
		return AxolotlClient.config().cloudHeight.get();
	}

	@ModifyArg(method = "renderBlockOutline", at = @At(value = "INVOKE", target = "Lorg/lwjgl/opengl/GL11;glLineWidth(F)V"), remap = false)
	public float axolotlclient$OutlineWidth(float width) {
		if (AxolotlClient.config().enableCustomOutlines.get() && AxolotlClient.config().outlineWidth.get() > 1) {
			return 1.0F + AxolotlClient.config().outlineWidth.get();
		}
		return width;
	}

	@Inject(method = "renderBlockOutline", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;depthMask(Z)V", ordinal = 1))
	private void resetOutlineWidth(C_9590849 playerEntity, C_7794883 hitResult, int i, float f4, CallbackInfo ci) {
		GL11.glLineWidth(2.0F);
	}

	@Inject(method = "renderBlockOutline", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/platform/GlStateManager;color4f(FFFF)V", shift = At.Shift.AFTER))
	public void axolotlclient$customOutlineColor(C_9590849 playerEntity, C_7794883 hitResult, int i, float f, CallbackInfo ci) {
		if (AxolotlClient.config().enableCustomOutlines.get()) {
			C_3754158.m_4384509();

			int color = AxolotlClient.config().outlineColor.get().toInt();
			float a = (float) (color >> 24 & 0xFF) / 255.0F;
			float r = (float) (color >> 16 & 0xFF) / 255.0F;
			float g = (float) (color >> 8 & 0xFF) / 255.0F;
			float b = (float) (color & 0xFF) / 255.0F;
			C_3754158.m_3323122(r, g, b, a);
		}
	}
}
