/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import java.util.ArrayList;
import java.util.List;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import lombok.Getter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class AccountsListWidget extends C_1630332 {

	private final AccountsScreen screen;
	private final List<Entry> entries = new ArrayList<>();
	private int selectedEntry = -1;

	public AccountsListWidget(AccountsScreen screen, C_8105098 client, int width, int height, int top, int bottom, int entryHeight) {
		super(client, width, height, top, bottom, entryHeight);
		this.screen = screen;
	}

	public void setAccounts(List<Account> accounts) {
		accounts.forEach(account -> entries.add(new Entry(screen, account)));
	}

	@Override
	protected int m_3791031() {
		return entries.size();
	}

	@Override
	public int m_6519286() {
		return super.m_6519286() + 85;
	}

	@Override
	protected int m_3021017() {
		return super.m_3021017() + 30;
	}

	@Override
	protected boolean m_5993229(int i) {
		return i == this.selectedEntry;
	}

	@Override
	public C_1630332.C_8277969 m_7118949(int i) {
		return entries.get(i);
	}

	public Entry getSelectedEntry() {
		if (getSelected() < 0) {
			return null;
		}
		return entries.get(getSelected());
	}

	public int getSelected() {
		return this.selectedEntry;
	}

	public void setSelected(int i) {
		this.selectedEntry = i;
	}

	@Environment(EnvType.CLIENT)
	public static class Entry extends DrawUtil implements C_1630332.C_8277969 {

		private static final C_0561170 checkmark = new C_0561170("axolotlclient", "textures/check.png");
		private static final C_0561170 warningSign = new C_0561170("axolotlclient", "textures/warning.png");

		private final AccountsScreen screen;
		@Getter
		private final Account account;
		private final C_8105098 client;
		private long time;

		public Entry(AccountsScreen screen, Account account) {
			this.screen = screen;
			this.account = account;
			this.client = C_8105098.m_0408063();
		}

		@Override
		public void m_1433237(int i, int j, int k) {

		}

		@Override
		public void m_2013749(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
			client.f_0426313.m_4683674(account.getName(), x + 3 + 33, y + 1, -1);
			client.f_0426313.m_4683674(account.getUuid(), x + 3 + 33, y + 12, 8421504);
			C_3754158.m_3323122(1, 1, 1, 1);
			if (Auth.getInstance().getCurrent().equals(account)) {
				client.m_1218956().m_5325521(checkmark);
				m_5935491(x - 35, y + 1, 0, 0, 32, 32, 32, 32);
			} else if (account.isExpired()) {
				client.m_1218956().m_5325521(warningSign);
				m_5935491(x - 35, y + 1, 0, 0, 32, 32, 32, 32);
			}
			C_3754158.m_3323122(1, 1, 1, 1);
			client.m_1218956().m_5325521(Auth.getInstance().getSkinTexture(account));
			C_3754158.m_9671730();
			m_4673442(x - 1, y - 1, 8, 8, 8, 8, 33, 33, 64, 64);
			m_4673442(x - 1, y - 1, 40, 8, 8, 8, 33, 33, 64, 64);
			C_3754158.m_5313301();

		}

		@Override
		public boolean m_3739705(int index, int mouseX, int mouseY, int button, int x, int y) {
			this.screen.select(index);
			if (C_8105098.m_6224581() - this.time < 250L && client.f_4601986 == null) {
				if (!getAccount().equals(Auth.getInstance().getCurrent())) {
					screen.select(-1);
					Auth.getInstance().login(account);
				}
			}

			this.time = C_8105098.m_6224581();
			return false;
		}

		@Override
		public void m_4703785(int i, int j, int k, int l, int m, int n) {

		}

	}
}
