/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import io.github.axolotlclient.modules.auth.skin.SkinManagementScreen;
import net.minecraft.unmapped.C_1441789;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;

public class AccountsScreen extends C_3020744 {
	private final C_3020744 parent;
	private final String title;
	protected AccountsListWidget accountsListWidget;
	private C_2348249 loginButton;
	private C_2348249 deleteButton;
	private C_2348249 refreshButton;
	private C_2348249 skinsButton;

	public AccountsScreen(C_3020744 currentScreen) {
		title = C_3390001.m_2053009("accounts");
		this.parent = currentScreen;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		this.m_7817195();
		this.accountsListWidget.m_9734698(mouseX, mouseY, delta);
		m_2717572(this.f_2020658, this.title, this.f_5465691 / 2, 20, 16777215);
		super.m_7261014(mouseX, mouseY, delta);
	}

	@Override
	protected void m_6992336(char c, int i) {
		int j = this.accountsListWidget.getSelected();
		C_1630332.C_8277969 entry = j < 0 ? null : this.accountsListWidget.m_7118949(j);
		if (i == 63) {
			this.refresh();
		} else {
			if (j >= 0) {
				if (i == 200) {
					if (m_5142737()) {
						if (j > 0 && entry instanceof AccountsListWidget.Entry) {
							this.select(this.accountsListWidget.getSelected() - 1);
							this.accountsListWidget.m_9909453(-this.accountsListWidget.m_6703043());
						}
					} else if (j > 0) {
						this.select(this.accountsListWidget.getSelected() - 1);
						this.accountsListWidget.m_9909453(-this.accountsListWidget.m_6703043());
					} else {
						this.select(-1);
					}
				} else if (i == 208) {
					if (m_5142737()) {
						this.select(j + 1);
						this.accountsListWidget.m_9909453(this.accountsListWidget.m_6703043());
					} else if (j < this.accountsListWidget.m_3791031()) {
						this.select(this.accountsListWidget.getSelected() + 1);
						this.accountsListWidget.m_9909453(this.accountsListWidget.m_6703043());
					} else {
						this.select(-1);
					}
				} else if (i != 28 && i != 156) {
					super.m_6992336(c, i);
				} else {
					this.m_7971793(this.f_2213969.get(2));
				}
			} else {
				super.m_6992336(c, i);
			}
		}
	}

	@Override
	protected void m_7362766(int i, int j, int k) {
		super.m_7362766(i, j, k);
		this.accountsListWidget.m_7379893(i, j, k);
	}

	@Override
	protected void m_5308748(int i, int j, int k) {
		super.m_5308748(i, j, k);
		this.accountsListWidget.m_9825864(i, j, k);
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		switch (buttonWidget.f_5920996) {
			case 0:
				this.f_7153641.m_6408915(this.parent);
				break;
			case 1:
				login();
				break;
			case 2:
				f_7153641.m_6408915(new SkinManagementScreen(
					this, accountsListWidget.getSelectedEntry().getAccount()));
				break;
			case 3:
				if (Auth.getInstance().allowOfflineAccounts()) {
					f_7153641.m_6408915(new C_1441789(this, C_3390001.m_2053009("auth.add.choose"), "", C_3390001.m_2053009("auth.add.offline"), C_3390001.m_2053009("auth.add.ms"), 234));
				} else {
					initMSAuth();
				}
				break;
			case 4:
				AccountsListWidget.Entry entry = this.accountsListWidget.getSelectedEntry();
				if (entry != null) {
					buttonWidget.f_3831222 = false;
					Auth.getInstance().removeAccount(entry.getAccount());
					refresh();
				}
				break;
			case 5:
				refreshAccount();
				break;
		}
	}

	@Override
	public void m_3593494() {

		accountsListWidget = new AccountsListWidget(this, f_7153641, f_5465691, f_3080061, 32, f_3080061 - 64, 35);

		accountsListWidget.setAccounts(Auth.getInstance().getAccounts());

		f_2213969.add(loginButton = new C_2348249(1, this.f_5465691 / 2 - 154, this.f_3080061 - 52, 100, 20, C_3390001.m_2053009("auth.login")));

		f_2213969.add(skinsButton = new C_2348249(2, this.f_5465691 / 2 - 50, this.f_3080061 - 52, 100, 20, C_3390001.m_2053009("skins.manage")));

		this.f_2213969.add(new C_2348249(3, this.f_5465691 / 2 + 4 + 50, this.f_3080061 - 52, 100, 20, C_3390001.m_2053009("auth.add")));

		this.f_2213969.add(this.deleteButton = new C_2348249(4, this.f_5465691 / 2 - 50, this.f_3080061 - 28, 100, 20, C_3390001.m_2053009("selectServer.delete")));


		this.f_2213969.add(refreshButton = new C_2348249(5, this.f_5465691 / 2 - 154, this.f_3080061 - 28, 100, 20,
			C_3390001.m_2053009("auth.refresh")));

		this.f_2213969.add(new C_2348249(0, this.f_5465691 / 2 + 4 + 50, this.f_3080061 - 28, 100, 20,
			C_3390001.m_2053009("gui.back")));
		updateButtonActivationStates();
	}

	@Override
	public void m_3356138() {
		super.m_3356138();
		this.accountsListWidget.m_1002325();
	}

	@Override
	public void m_8984281() {
		Auth.getInstance().save();
	}

	@Override
	public void m_7743236(boolean bl, int i) {
		if (i == 234) {
			if (!bl) {
				f_7153641.m_6408915(this);
				initMSAuth();
			} else {
				f_7153641.m_6408915(new AddOfflineScreen(this));
			}
		}
	}

	private void refresh() {
		this.f_7153641.m_6408915(new AccountsScreen(this.parent));
	}

	public void select(int index) {
		this.accountsListWidget.setSelected(index);
		this.updateButtonActivationStates();
	}

	private void updateButtonActivationStates() {
		AccountsListWidget.Entry entry = accountsListWidget.getSelectedEntry();
		if (f_7153641.f_4601986 == null && entry != null) {
			loginButton.f_3831222 = entry.getAccount().isExpired() || !entry.getAccount().equals(Auth.getInstance().getCurrent());
			refreshButton.f_3831222 = skinsButton.f_3831222 = !entry.getAccount().isOffline();
			deleteButton.f_3831222 = true;
		} else {
			loginButton.f_3831222 = deleteButton.f_3831222 = refreshButton.f_3831222 = skinsButton.f_3831222 = false;
		}
	}

	private void login() {
		loginButton.f_3831222 = false;
		AccountsListWidget.Entry entry = accountsListWidget.getSelectedEntry();
		if (entry != null) {
			Auth.getInstance().login(entry.getAccount());
		}
	}

	private void initMSAuth() {
		Auth.getInstance().getMsApi().startDeviceAuth().thenRun(() -> minecraft.submit(this::refresh));
	}

	private void refreshAccount() {
		refreshButton.f_3831222 = false;
		AccountsListWidget.Entry entry = accountsListWidget.getSelectedEntry();
		if (entry != null) {
			entry.getAccount().refresh(Auth.getInstance().getMsApi());
		}
	}
}
