/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import java.util.UUID;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2925725;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;

public class AddOfflineScreen extends C_3020744 {

	private final C_3020744 parent;
	private C_2925725 nameInput;

	public AddOfflineScreen(C_3020744 parent) {
		this.parent = parent;
	}


	@Override
	public void m_7261014(int i, int j, float f) {
		m_7817195();
		super.m_7261014(i, j, f);
		f_2020658.m_1950885(C_3390001.m_2053009("auth.add.offline.name"), f_5465691 / 2F - 100, f_3080061 / 2f - 20, -1);
		m_2717572(this.f_2020658, C_3390001.m_2053009("auth.add.offline"), this.f_5465691 / 2, 20, 16777215);
		nameInput.m_1620442();
	}

	@Override
	protected void m_6992336(char c, int i) {
		nameInput.m_1973329(c, i);
	}

	@Override
	protected void m_7362766(int i, int j, int k) {
		super.m_7362766(i, j, k);
		nameInput.m_1129375(i, j, k);
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 1) {
			f_7153641.m_6408915(parent);
		} else if (buttonWidget.f_5920996 == 2) {
			Auth.getInstance().addAccount(new Account(nameInput.m_4862541(), UUID.randomUUID().toString(), Account.OFFLINE_TOKEN));
			f_7153641.m_6408915(parent);
		}
	}

	@Override
	public void m_3593494() {
		nameInput = new C_2925725(0, f_2020658, f_5465691 / 2 - 100, f_3080061 / 2 - 10, 200, 20);

		f_2213969.add(new C_2348249(1, f_5465691 / 2 - 155, f_3080061 - 50, 150, 20, C_3390001.m_2053009("gui.cancel")));
		f_2213969.add(new C_2348249(2, f_5465691 / 2 + 5, f_3080061 - 50, 150, 20, C_3390001.m_2053009("gui.done")));
	}

	@Override
	public void m_2450377() {
		nameInput.m_0296611();
	}
}
