/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import io.github.axolotlclient.api.API;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;

public class AuthWidget extends C_2348249 {

	public AuthWidget(int x, int y) {
		super(242, x, y,
			C_8105098.m_0408063().f_0426313.m_0040387(Auth.getInstance().getCurrent().getName()) + 28,
			20, "    " + Auth.getInstance().getCurrent().getName());
	}

	@Override
	public void m_5350167(C_8105098 minecraftClient, int i, int j) {
		super.m_5350167(minecraftClient, i, j);
		C_3754158.m_3323122(1, 1, 1, 1);
		C_8105098.m_0408063().m_1218956().m_5325521(Auth.getInstance().getSkinTexture(Auth.getInstance().getCurrent()));
		C_3754158.m_9671730();
		m_4673442(f_3923091 + 1, f_8532347 + 1, 8, 8, 8, 8, f_7845401 - 2, f_7845401 - 2, 64, 64);
		m_4673442(f_3923091 + 1, f_8532347 + 1, 40, 8, 8, 8, f_7845401 - 2, f_7845401 - 2, 64, 64);
		C_3754158.m_5313301();
		if (API.getInstance().getApiOptions().enabled.get()) {
			C_3754158.m_8373640();
			C_3754158.m_3172490(f_3923091 + f_7845401 - 1, f_8532347 + f_7845401 - 1, 0);
			C_3754158.m_4552250(0.25f, 0.25f, 1);
			C_3754158.m_3172490(-8, -8, 0);
			int color = API.getInstance().getIndicatorColor();
			m_7865719(0, 4, 16, 12, color);
			m_7865719(4, 0, 12, 16, color);
			m_7865719(2, 2, 14, 14, color);
			C_3754158.m_2041265();
		}
	}
}
