/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import java.net.URI;
import java.util.List;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_8105098;
import io.github.axolotlclient.util.OSUtil;
import io.github.axolotlclient.util.Util;

public class DeviceCodeDisplayScreen extends C_3020744 {
	private final C_3020744 parent;
	private final String verificationUri, userCode;
	private final List<String> message;
	private final String title;
	private int ticksLeft;
	private String status;
	private boolean working;
	private final C_0561170 qrCode;
	private final DeviceFlowData data;

	public DeviceCodeDisplayScreen(C_3020744 parent, DeviceFlowData data) {
		super();
		this.title = C_3390001.m_2053009("auth.add");
		this.parent = parent;
		this.message = C_8105098.m_0408063().f_0426313.m_0466830(data.getMessage(), 400);
		this.verificationUri = data.getVerificationUri();
		this.userCode = data.getUserCode();
		this.ticksLeft = data.getExpiresIn() * 20;
		this.qrCode = Util.getTexture(data.getQrCode(), "device_auth_" + data.getUserCode());
		this.status = C_3390001.m_2053009("auth.time_left",
			((ticksLeft / 20) / 60) + "m" + ((ticksLeft / 20) % 60) + "s");
		data.setStatusConsumer(s -> {
			if (s.equals("auth.finished")) {
				C_8105098.m_0408063().m_2167033(() -> C_8105098.m_0408063().m_6408915(parent));
			}
			working = true;
			f_2213969.clear();
			status = C_3390001.m_2053009(s);
		});
		this.data = data;
	}

	@Override
	public void m_8984281() {
		data.cancel();
	}

	@Override
	public void m_3593494() {
		f_2213969.add(new C_2348249(1, f_5465691 / 2 - 100, f_3080061 / 2,
			200, 20, C_3390001.m_2053009("auth.copy_and_open")));
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_7817195();
		super.m_7261014(mouseX, mouseY, delta);

		m_2717572(f_7153641.f_0426313, title, f_5465691 / 2, 25, -1);

		int y = f_3080061 / 4;
		for (String text : message) {
			f_7153641.f_0426313.m_1950885(text, f_5465691 / 2f - f_7153641.f_0426313.m_0040387(text) / 2f, y, -1);
			y += 10;
		}
		m_2717572(f_7153641.f_0426313, working ? status : C_3390001.m_2053009("auth.time_left",
				((ticksLeft / 20) / 60) + "m" + ((ticksLeft / 20) % 60) + "s"),
			f_5465691 / 2, y + 10, -1);


		y = f_3080061 / 2 + 30;
		if (f_3080061 - y > 40) {
			int qrImageSize = f_3080061 - y - 20;
			f_7153641.m_1218956().m_5325521(qrCode);
			m_5935491(f_5465691 / 2 - qrImageSize / 2, y, 0, 0, qrImageSize, qrImageSize, qrImageSize, qrImageSize);
		}
	}

	@Override
	public void m_2450377() {
		ticksLeft--;
	}

	@Override
	protected void m_7971793(C_2348249 buttonWidget) {
		if (buttonWidget.f_5920996 == 1) {
			m_5360526(userCode);
			OSUtil.getOS().open(URI.create(verificationUri));
		}
	}
}
