/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth.skin;

import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_8105098;

public class LoadingScreen extends C_3020744 {
	private final String description;
	private final String title;

	public LoadingScreen(String title, String description) {
		super();
		this.title = title;
		this.description = description;
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		m_7817195();
		m_2717572(f_2020658, title, f_5465691 / 2, 33 / 2 - f_2020658.f_6725889 / 2, -1);
		int centerX = f_5465691 / 2;
		int centerY = f_3080061 / 2;
		var text = description;
		f_2020658.m_4683674(text, centerX - f_2020658.m_0040387(text) / 2, centerY - 9, -1);
		String string = switch ((int) (C_8105098.m_6224581() / 300L % 4L)) {
			case 1, 3 -> "o O o";
			case 2 -> "o o O";
			default -> "O o o";
		};
		f_2020658.m_4683674(string, centerX - f_2020658.m_0040387(string) / 2, centerY + 9, 0xFF808080);
	}
}
