/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth.skin;

import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0946921;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_5585855;
import net.minecraft.unmapped.C_8105098;
import org.jetbrains.annotations.Nullable;

public class SkinRenderer {
	private static C_0946921 classicModel, slimModel;
	private static final C_8105098 minecraft = C_8105098.m_0408063();

	private SkinRenderer() {
	}

	public static void render(boolean classicVariant,
							  C_0561170 skinTexture,
							  @Nullable C_0561170 cape,
							  float rotationX,
							  float rotationY,
							  float pivotY,
							  int x0,
							  int y0,
							  int x1,
							  int y1,
							  float scale) {

		if (classicModel == null && classicVariant) {
			classicModel = new C_0946921(0, false);
			classicModel.f_9861369 = false;
			classicModel.m_8051874(true);
		}
		if (slimModel == null && !classicVariant) {
			slimModel = new C_0946921(0, true);
			slimModel.f_9861369 = false;
			slimModel.m_8051874(true);
		}

		int width = x1 - x0;
		int light = 15728880;
		C_5585855.m_8571830(C_5585855.f_3392938, light % 65536, light / 65536f);
		C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
		C_3754158.m_8373640();
		C_3754158.m_3172490(x0 + width / 2.0F, (float) (y1), 00.0F);
		C_3754158.m_4552250(scale, scale, 1);
		C_3754158.m_3172490(0.0F, -0.0625F, 0.0F);
		C_3754158.m_3172490(0, pivotY, 0);
		C_3754158.m_8616673(rotationX, 1, 0, 0);
		C_3754158.m_3172490(0, -pivotY, 0);
		C_3754158.m_8616673(rotationY, 0, 1, 0);
		C_3754158.m_8373640();
		C_3754158.m_4552250(1.0F, 1.0F, -1.0F);
		C_3754158.m_3172490(0.0F, -1.5F, 0.0F);
		var model = classicVariant ? classicModel : slimModel;
		minecraft.m_1218956().m_5325521(skinTexture);
		C_3754158.m_9671730();
		C_3754158.m_9078814();
		C_3754158.m_8373640();
		float k = 0.0625F;
		model.f_5519877.m_3467157(k);
		model.f_2867501.m_3467157(k);
		model.f_8519311.m_3467157(k);
		model.f_2523455.m_3467157(k);
		model.f_6076649.m_3467157(k);
		model.f_4246077.m_3467157(k);
		model.f_2072821.m_3467157(k);
		model.f_1100702.m_3467157(k);
		model.m_2612902();
		model.f_7557714.m_3467157(0.0625F);
		C_3754158.m_3172490(0, 0, -0.62F); // why?
		model.f_3784957.m_3467157(0.0625F);
		C_3754158.m_2041265();
		if (cape != null) {
			C_3754158.m_8373640();
			minecraft.m_1218956().m_5325521(cape);
			C_3754158.m_3172490(0.0F, 0.0F, 0.125F);
			C_3754158.m_8616673(6.0F, 1, 0, 0);
			C_3754158.m_8616673(180.0F, 0, 1, 0);
			model.m_5855701(0.0625F);
			C_3754158.m_2041265();
		}
		C_3754158.m_2041265();
		C_3754158.m_2041265();
		C_3754158.m_5313301();
		C_3754158.m_7027522();
	}
}
