/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.blur;

import java.io.IOException;
import java.io.InputStream;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.mixin.MinecraftClientAccessor;
import io.github.axolotlclient.mixin.ShaderEffectAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Util;
import lombok.Getter;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0731481;
import net.minecraft.unmapped.C_1616310;
import net.minecraft.unmapped.C_1676943;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_4811147;
import net.minecraft.unmapped.C_7669754;
import net.minecraft.unmapped.C_8105098;
import org.apache.commons.io.IOUtils;

/**
 * Totally not stolen from Sol.
 * License: GPL-3.0
 *
 * @author TheKodeToad
 * @author tterag1098
 */

public class MenuBlur extends AbstractModule {

	@Getter
	private static final MenuBlur Instance = new MenuBlur();
	public final BooleanOption enabled = new BooleanOption("enabled", false);
	private final C_0561170 shaderLocation = new C_0561170("minecraft:shaders/post/menu_blur.json");
	private final IntegerOption strength = new IntegerOption("strength", 8, 0, 100);
	private final IntegerOption fadeTime = new IntegerOption("fadeTime", 1, 0, 10);
	private final ColorOption bgColor = new ColorOption("bgcolor", new Color(0x64000000));
	private final OptionCategory category = OptionCategory.create("menublur");

	private final Color black = new Color(0);

	private long openTime;

	private C_1616310 shader;

	private int lastWidth;
	private int lastHeight;

	@Override
	public void init() {
		category.add(enabled, strength, fadeTime, bgColor);

		AxolotlClient.config().rendering.add(category);

		AxolotlClient.runtimeResources.put(shaderLocation, new MenuBlurShader());
	}

	public boolean renderScreen() {
		if (enabled.get() && !(C_8105098.m_0408063().f_0723335 instanceof C_7669754) && shader != null) {
			C_2691939.m_7865719(0, 0, Util.getWindow().m_1713651(), Util.getWindow().m_5421693(),
				ClientColors.blend(black, bgColor.get(), getProgress()).toInt());
			return true;
		}
		return false;
	}

	private float getProgress() {
		return Math.min((System.currentTimeMillis() - openTime) / (fadeTime.get() * 1000F), 1);
	}

	public void updateBlur() {
		if (enabled.get() && C_8105098.m_0408063().f_0723335 != null && !(C_8105098.m_0408063().f_0723335 instanceof C_7669754)) {
			if ((shader == null || client.f_0545414 != lastWidth || client.f_5990000 != lastHeight) && client.f_5990000 != 0
				&& client.f_0545414 != 0) {
				try {
					shader = new C_1616310(client.m_1218956(), client.m_3739907(),
						client.m_4441537(), shaderLocation);
					shader.m_0289132(client.f_0545414, client.f_5990000);
				} catch (IOException e) {
					AxolotlClient.LOGGER.error("Failed to load Menu Blur: ", e);
					return;
				}
			}

			if (shader != null) {
				((ShaderEffectAccessor) shader).getPasses().forEach((shader) -> {
					C_4811147 radius = shader.m_5385513().m_4711234("Radius");
					C_4811147 progress = shader.m_5385513().m_4711234("Progress");

					if (radius != null) {
						radius.m_1456501(strength.get());
					}

					if (progress != null) {
						if (fadeTime.get() > 0) {
							progress.m_1456501(getProgress());
						} else {
							progress.m_1456501(1);
						}
					}
				});
			}

			lastWidth = client.f_0545414;
			lastHeight = client.f_5990000;
			renderBlur();
		}
	}

	public void renderBlur() {
		shader.m_0877167(((MinecraftClientAccessor) C_8105098.m_0408063()).getTicker().f_7092791);
	}

	public void onScreenOpen() {
		openTime = System.currentTimeMillis();
	}

	private static class MenuBlurShader implements C_1676943 {

		@Override
		public C_0561170 m_1808586() {
			return null;
		}

		@Override
		public InputStream m_3098790() {
			return IOUtils.toInputStream("{\n" + "    \"targets\": [\n" + "        \"swap\"\n" + "    ],\n"
				+ "    \"passes\": [\n" + "        {\n" + "            \"name\": \"menu_blur\",\n"
				+ "            \"intarget\": \"minecraft:main\",\n" + "            \"outtarget\": \"swap\",\n"
				+ "            \"uniforms\": [\n" + "                {\n"
				+ "                    \"name\": \"BlurDir\",\n" + "                    \"values\": [ 1.0, 0.0 ]\n"
				+ "                },\n" + "                {\n" + "                    \"name\": \"Radius\",\n"
				+ "                    \"values\": [ 0.0 ]\n" + "                }\n" + "            ]\n"
				+ "        },\n" + "        {\n" + "            \"name\": \"menu_blur\",\n"
				+ "            \"intarget\": \"swap\",\n" + "            \"outtarget\": \"minecraft:main\",\n"
				+ "            \"uniforms\": [\n" + "                {\n"
				+ "                    \"name\": \"BlurDir\",\n" + "                    \"values\": [ 0.0, 1.0 ]\n"
				+ "                },\n" + "                {\n" + "                    \"name\": \"Radius\",\n"
				+ "                    \"values\": [ 0.0 ]\n" + "                }\n" + "            ]\n"
				+ "        },\n" + "        {\n" + "            \"name\": \"menu_blur\",\n"
				+ "            \"intarget\": \"minecraft:main\",\n" + "            \"outtarget\": \"swap\",\n"
				+ "            \"uniforms\": [\n" + "                {\n"
				+ "                    \"name\": \"BlurDir\",\n" + "                    \"values\": [ 1.0, 0.0 ]\n"
				+ "                },\n" + "                {\n" + "                    \"name\": \"Radius\",\n"
				+ "                    \"values\": [ 0.0 ]\n" + "                }\n" + "            ]\n"
				+ "        },\n" + "        {\n" + "            \"name\": \"menu_blur\",\n"
				+ "            \"intarget\": \"swap\",\n" + "            \"outtarget\": \"minecraft:main\",\n"
				+ "            \"uniforms\": [\n" + "                {\n"
				+ "                    \"name\": \"BlurDir\",\n" + "                    \"values\": [ 0.0, 1.0 ]\n"
				+ "                },\n" + "                {\n" + "                    \"name\": \"Radius\",\n"
				+ "                    \"values\": [ 0.0 ]\n" + "                }\n" + "            ]\n"
				+ "        }\n" + "    ]\n" + "}");
		}

		@Override
		public boolean m_5807457() {
			return false;
		}

		@Override
		public <T extends C_0731481> T m_5396002(String key) {
			return null;
		}

		@Override
		public String m_6204189() {
			return null;
		}
	}
}
