/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.blur;

import java.io.IOException;
import java.io.InputStream;

import com.google.gson.JsonSyntaxException;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.mixin.ShaderEffectAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import lombok.Getter;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_0731481;
import net.minecraft.unmapped.C_1616310;
import net.minecraft.unmapped.C_1676943;
import net.minecraft.unmapped.C_4811147;
import org.apache.commons.io.IOUtils;

public class MotionBlur extends AbstractModule {

	@Getter
	private static final MotionBlur Instance = new MotionBlur();
	public final BooleanOption enabled = new BooleanOption("enabled", false);
	public final FloatOption strength = new FloatOption("strength", 50F, 1F, 99F);
	public final BooleanOption inGuis = new BooleanOption("inGuis", false);
	public final OptionCategory category = OptionCategory.create("motionBlur");
	private final C_0561170 shaderLocation = new C_0561170("minecraft:shaders/post/motion_blur.json");
	public C_1616310 shader;
	private float currentBlur;

	private int lastWidth;
	private int lastHeight;

	private static float getBlur() {
		return MotionBlur.getInstance().strength.get() / 100F;
	}

	@Override
	public void init() {
		category.add(enabled, strength, inGuis);

		AxolotlClient.config().rendering.add(category);

		AxolotlClient.runtimeResources.put(shaderLocation, new MotionBlurShader());
	}

	public void onUpdate() {
		if ((shader == null || client.f_0545414 != lastWidth || client.f_5990000 != lastHeight) && client.f_5990000 != 0
			&& client.f_0545414 != 0) {
			currentBlur = getBlur();
			try {
				shader = new C_1616310(client.m_1218956(), client.m_3739907(),
					client.m_4441537(), shaderLocation);
				shader.m_0289132(client.f_0545414, client.f_5990000);
			} catch (JsonSyntaxException | IOException e) {
				AxolotlClient.LOGGER.error("Could not load motion blur: ", e);
			}
		}
		if (currentBlur != getBlur()) {
			((ShaderEffectAccessor) shader).getPasses().forEach(shader -> {
				C_4811147 blendFactor = shader.m_5385513().m_4711234("BlendFactor");
				if (blendFactor != null) {
					blendFactor.m_1456501(getBlur());
				}
			});
			currentBlur = getBlur();
		}

		lastWidth = client.f_0545414;
		lastHeight = client.f_5990000;
	}

	private static class MotionBlurShader implements C_1676943 {

		@Override
		public C_0561170 m_1808586() {
			return null;
		}

		@Override
		public InputStream m_3098790() {
			return IOUtils.toInputStream(String.format("{" + "    \"targets\": [" + "        \"swap\","
				+ "        \"previous\"" + "    ]," + "    \"passes\": [" + "        {"
				+ "            \"name\": \"motion_blur\"," + "            \"intarget\": \"minecraft:main\","
				+ "            \"outtarget\": \"swap\"," + "            \"auxtargets\": [" + "                {"
				+ "                    \"name\": \"PrevSampler\"," + "                    \"id\": \"previous\""
				+ "                }" + "            ]," + "            \"uniforms\": [" + "                {"
				+ "                    \"name\": \"BlendFactor\"," + "                    \"values\": [ %s ]"
				+ "                }" + "            ]" + "        }," + "        {"
				+ "            \"name\": \"blit\"," + "            \"intarget\": \"swap\","
				+ "            \"outtarget\": \"previous\"" + "        }," + "        {"
				+ "            \"name\": \"blit\"," + "            \"intarget\": \"swap\","
				+ "            \"outtarget\": \"minecraft:main\"" + "        }" + "    ]" + "}", getBlur()));
		}

		@Override
		public boolean m_5807457() {
			return false;
		}

		@Override
		public <T extends C_0731481> T m_5396002(String key) {
			return null;
		}

		@Override
		public String m_6204189() {
			return null;
		}
	}
}
