/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.PlayerDirectionChangeEvent;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import lombok.Getter;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_1023567;
import net.minecraft.unmapped.C_2899740;
import net.minecraft.unmapped.C_3362006;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_5585855;
import net.minecraft.unmapped.C_8048208;
import net.minecraft.unmapped.C_8105098;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class PlayerHud extends PlayerHudCommon {

	public static final C_0561170 ID = new C_0561170("kronhud", "playerhud");
	@Getter
	private static boolean currentlyRendering = false;

	public PlayerHud() {
		super();
		Events.PLAYER_DIRECTION_CHANGE.register(this::onPlayerDirectionChange);
	}

	public void onPlayerDirectionChange(PlayerDirectionChangeEvent event) {
		yawOffset += (event.yaw() - event.prevYaw()) / 2;
	}

	@Override
	public void tick() {
		super.tick();
		yOffset *= .8f;
	}

	@Override
	protected void renderPlayer(AxoRenderContext ctx, boolean placeholder, double x, double y, float delta) {
		C_3754158.m_2041265();
		C_3754158.m_8373640();

		var client = C_8105098.m_0408063();
		if (client.f_7663840 == null) {
			return;
		}

		if (!placeholder && autoHide.get()) {
			if (isPerformingAction()) {
				hide = -1;
			} else if (hide == -1) {
				hide = System.currentTimeMillis();
			}

			if (hide != -1 && System.currentTimeMillis() - hide > 500) {
				return;
			}
		}

		float lerpY = (lastYOffset + ((yOffset - lastYOffset) * delta));

		C_3754158.m_3323122(1, 1, 1, 1);
		C_3754158.m_7424052();
		C_3754158.m_8373640();
		C_3754158.m_5322104(x, y - lerpY, 1050);
		C_3754158.m_4552250(1, 1, -1);

		C_3754158.m_3172490(0, 0, 1000);
		float scale = getScale() * 40;
		C_3754158.m_4552250(scale, scale, scale);

		C_3754158.m_8616673(180, 0, 0, 1);

		// Rotate to whatever is wanted. Also make sure to offset the yaw
		float deltaYaw = client.f_7663840.f_7165431;
		if (dynamicRotation.get()) {
			deltaYaw -= (lastYawOffset + ((yawOffset - lastYawOffset) * delta));
		}

		// Save these to set them back later
		float pastYaw = client.f_7663840.f_7165431;
		float pastBodyYaw = client.f_7663840.f_3138638;
		float pastHeadYaw = client.f_7663840.f_7005130;
		float pastPrevHeadYaw = client.f_7663840.f_3228610;
		float pastPrevYaw = client.f_7663840.f_5055140;

		client.f_7663840.f_7005130 = client.f_7663840.f_7165431;
		client.f_7663840.f_3228610 = client.f_7663840.f_7165431;

		C_3754158.m_8616673(deltaYaw - 180 + rotation.get().floatValue(), 0, 1, 0);
		C_2899740.m_3229588();
		C_3362006 renderer = client.m_5440205();
		renderer.m_3106281(180);
		renderer.f_2592027 = 0;
		renderer.m_2324704(false);

		currentlyRendering = true;
		renderer.m_6525255(client.f_7663840, 0.0, 0.0, 0.0, 0, delta);
		currentlyRendering = false;

		renderer.m_2324704(true);
		C_3754158.m_2041265();

		client.f_7663840.f_7165431 = pastYaw;
		client.f_7663840.f_7005130 = pastHeadYaw;
		client.f_7663840.f_3228610 = pastPrevHeadYaw;
		client.f_7663840.f_5055140 = pastPrevYaw;
		client.f_7663840.f_3138638 = pastBodyYaw;

		C_2899740.m_8989115();
		C_3754158.m_6240595();
		C_3754158.m_5186483(C_5585855.f_3392938);
		C_3754158.m_2090124();
		C_3754158.m_5186483(C_5585855.f_0448360);
	}

	private boolean isPerformingAction() {
		// inspired by tr7zw's mod
		C_1023567 player = C_8105098.m_0408063().f_7663840;
		return player.m_4153657() || player.m_4988218() || player.f_7045253.f_2276411
			|| player.m_0217121(C_8048208.f_0913582) || player.m_1888316() || player.m_2916573()
			|| player.f_1813673 || player.f_0297948 > 0 || player.m_1903739();
	}
}
