/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.List;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DefaultOptions;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.util.ClientColors;
import lombok.RequiredArgsConstructor;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_7248549;
import net.minecraft.unmapped.C_8105098;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class BossBarHud extends TextHudEntry implements DynamicallyPositionable {

	public static final C_0561170 ID = new C_0561170("kronhud", "bossbarhud");
	private static final C_0561170 BARS_TEXTURE = new C_0561170("textures/gui/icons.png");
	private final CustomBossBar placeholder = new CustomBossBar("Boss bar", ClientColors.WHITE);

	private final BooleanOption text = new BooleanOption("text", true);
	private final BooleanOption bar = new BooleanOption("bar", true);
	// TODO custom color
	private final EnumOption<AnchorPoint> anchor = DefaultOptions.getAnchorPoint(AnchorPoint.TOP_MIDDLE);

	private final C_8105098 client = (C_8105098) super.client;

	public BossBarHud() {
		super(184, 24, false);
	}

	@Override
	public void renderComponent(AxoRenderContext context, float delta) {
		C_3754158.m_2754767();
		DrawPosition pos = getPos();
		if (C_7248549.f_4254848 != null && C_7248549.f_6476929 > 0) {
			client.m_1218956().m_5325521(BARS_TEXTURE);
			--C_7248549.f_6476929;
			if (bar.get()) {
				C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
				//GlStateManager.color4f(barColor.get().getRed(), barColor.get().getGreen(), barColor.get().getBlue(), barColor.get().getAlpha());
				DrawUtil.m_5935491(pos.x, pos.y + 12, 0, 74, 182, 5, 256, 256);
				DrawUtil.m_5935491(pos.x, pos.y + 12, 0, 74, 182, 5, 256, 256);
				if (C_7248549.f_8146873 * 183F > 0) {
					//GlStateManager.color4f(barColor.get().getRed(), barColor.get().getGreen(), barColor.get().getBlue(), barColor.get().getAlpha());
					DrawUtil.m_5935491(pos.x, pos.y + 12, 0, 79, (int) (C_7248549.f_8146873 * 183F), 5, 256, 256);
				}
			}

			C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
			if (text.get()) {
				String string = C_7248549.f_4254848;
				client.f_0426313.m_4413321(string,
					(float) ((pos.x + width / 2) - client.f_0426313.m_0040387(C_7248549.f_4254848) / 2),
					(float) (pos.y + 2), textColor.get().toInt(), shadow.get());
			}
		}
	}

	@Override
	public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
		DrawPosition pos = getPos();
		placeholder.render(pos.x, pos.y + 14);
	}

	@Override
	public C_0561170 getId() {
		return ID;
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> options = super.getConfigurationOptions();
		options.add(hide);
		options.add(text);
		options.add(bar);
		options.add(anchor);
		return options;
	}

	@Override
	public AnchorPoint getAnchor() {
		return anchor.get();
	}

	@RequiredArgsConstructor
	public class CustomBossBar extends C_2691939 {

		private final String name;
		private final Color barColor;

		public void render(int x, int y) {
			C_3754158.m_7547086();
			if (bar.get()) {
				C_8105098.m_0408063().m_1218956().m_5325521(BARS_TEXTURE);
				C_3754158.m_3323122(barColor.getRed(), barColor.getGreen(), barColor.getBlue(), barColor.getAlpha());
				this.m_4354119(x + 1, y, 0, 79, width, 5);
			}

			C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
			if (text.get()) {
				client.f_0426313.m_4413321(name, (float) ((x + width / 2) - client.f_0426313.m_0040387(name) / 2),
					(float) (y - 10), textColor.get().toInt(), shadow.get());
			}
		}
	}
}
