/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.List;
import net.minecraft.unmapped.C_2691939;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4018501;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_7650729;
import net.minecraft.unmapped.C_7794883;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_8931049;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.AbstractHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.RenderUtil;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Util;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class CrosshairHud extends AbstractHudEntry implements DynamicallyPositionable {

	public static final AxoIdentifier ID = AxoIdentifier.of("kronhud", "crosshairhud");

	private final EnumOption<Crosshair> type = new EnumOption<>("crosshair_type", Crosshair.class, Crosshair.CROSS);
	private final BooleanOption showInF5 = new BooleanOption("showInF5", false);
	private final BooleanOption applyBlend = new BooleanOption("applyBlend", true);
	private final BooleanOption overrideF3 = new BooleanOption("overrideF3", false);
	private final ColorOption defaultColor = new ColorOption("defaultcolor", ClientColors.WHITE);
	private final ColorOption entityColor = new ColorOption("entitycolor", ClientColors.SELECTOR_RED);
	private final ColorOption containerColor = new ColorOption("blockcolor", ClientColors.SELECTOR_BLUE);

	private final GraphicsOption customTextureGraphics = new GraphicsOption("customTextureGraphics",
		new int[][]{
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
			new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},});

	private final C_8105098 client = (C_8105098) super.client;

	public CrosshairHud() {
		super(15, 15);
	}

	@Override
	public AxoIdentifier getId() {
		return ID;
	}

	@Override
	public boolean movable() {
		return false;
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> options = super.getConfigurationOptions();
		options.add(hide);
		options.add(type);
		options.add(customTextureGraphics);
		options.add(showInF5);
		options.add(overrideF3);
		options.add(applyBlend);
		options.add(defaultColor);
		options.add(entityColor);
		options.add(containerColor);
		return options;
	}

	@Override
	public boolean overridesF3() {
		return overrideF3.get();
	}

	@Override
	public double getDefaultX() {
		return 0.5;
	}

	@Override
	public double getDefaultY() {
		return 0.5F;
	}

	@Override
	public void render(AxoRenderContext context, float delta) {
		if (!(client.f_9967940.f_3094045 == 0) && !showInF5.get())
			return;

		C_3754158.m_2754767();

		C_3754158.m_8373640();
		scale(context);
		Color color = getColor();
		C_3754158.m_3323122((float) color.getRed() / 255, (float) color.getGreen() / 255,
			(float) color.getBlue() / 255, 1F);
		if (color == defaultColor.get() && applyBlend.get()) {
			C_3754158.m_9671730();
			C_3754158.m_0833259(775, 769, 1, 0);
		}

		int x = getPos().x;
		int y = getPos().y + 1;
		if (type.get().equals(Crosshair.DOT)) {
			RenderUtil.fillBlend(x + (width / 2) - 1, y + (height / 2) - 2, 3, 3, color);
		} else if (type.get().equals(Crosshair.CROSS)) {
			RenderUtil.fillBlend(x + (width / 2) - 5, y + (height / 2) - 1, 6, 1, color);
			RenderUtil.fillBlend(x + (width / 2) + 1, y + (height / 2) - 1, 5, 1, color);
			RenderUtil.fillBlend(x + (width / 2), y + (height / 2) - 6, 1, 5, color);
			RenderUtil.fillBlend(x + (width / 2), y + (height / 2), 1, 5, color);
		} else if (type.get().equals(Crosshair.TEXTURE)) {
			C_8105098.m_0408063().m_1218956().m_5325521(C_2691939.f_7113512);

			// Draw crosshair
			//noinspection DataFlowIssue
			client.f_3501374.m_4354119((int) (((Util.getWindow().m_3624537() / getScale()) - 14) / 2),
				(int) (((Util.getWindow().m_6423725() / getScale()) - 14) / 2), 0, 0, 16, 16);
		} else if (type.get().equals(Crosshair.CUSTOM)) {
			Util.bindTexture(customTextureGraphics);
			DrawUtil.m_5935491(x + (width / 2) - (15 / 2), y + height / 2 - 15 / 2 - 1, 0, 0, 15, 15, 15, 15);
		}
		C_3754158.m_3323122(1, 1, 1, 1);
		C_3754158.m_0833259(770, 771, 1, 0);
		C_3754158.m_5313301();
		C_3754158.m_2041265();
		C_3754158.m_6191982();
	}

	public Color getColor() {
		C_7794883 hit = client.f_3593768;
		if (hit == null || hit.f_3002973 == null) {
			return defaultColor.get();
		} else if (hit.f_3002973 == C_7794883.C_3219935.f_1385333) {
			return entityColor.get();
		} else if (hit.f_3002973 == C_7794883.C_3219935.f_9738847) {
			C_3674802 blockPos = hit.m_1760520();
			C_5553933 world = this.client.f_4601986;
			if (world.m_4919395(blockPos).m_0999604() != null
				&& (world.m_4919395(blockPos).m_0999604() instanceof C_7650729
				|| world.m_4919395(blockPos).m_0999604() instanceof C_8931049
				|| world.m_4919395(blockPos).m_0999604() instanceof C_4018501)) {
				return containerColor.get();
			}
		}
		return defaultColor.get();
	}

	@Override
	public void renderPlaceholder(AxoRenderContext context, float delta) {
		// Shouldn't need this...
	}

	@Override
	public AnchorPoint getAnchor() {
		return AnchorPoint.MIDDLE_MIDDLE;
	}

	public enum Crosshair {
		CROSS, DOT, TEXTURE, CUSTOM
	}
}
