/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.List;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_8105098;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;

public class DebugCountersHud extends TextHudEntry implements DynamicallyPositionable {
	public static final C_0561170 ID = new C_0561170("axolotlclient", "debugcountershud");
	private final EnumOption<AnchorPoint> anchor = new EnumOption<>("anchorpoint", AnchorPoint.class,
		AnchorPoint.TOP_LEFT);
	private final BooleanOption showCCount = new BooleanOption("debugcounters.ccount", true);
	private final BooleanOption showECount = new BooleanOption("debugcounters.ecount", false);
	private final BooleanOption showPCount = new BooleanOption("debugcounters.pcount", false);

	private final C_8105098 client = (C_8105098) super.client;

	public DebugCountersHud() {
		super(115, 32, true);
	}

	@Override
	public void renderComponent(AxoRenderContext context, float delta) {
		if (client.f_4601986 == null) {
			renderPlaceholderComponent(context, delta);
		}
		DrawPosition pos = getPos();
		int lineY = pos.y() + 2;
		int lineX = pos.x() + 1;

		int xEnd = lineX + 50;
		if (showCCount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString(client.f_4021716.m_4313156(), lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}
		if (showECount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString(client.f_4021716.m_2254866(), lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}
		if (showPCount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString("P: " + client.f_9322491.m_0882495(), lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}

		boolean boundsChanged = false;
		if (lineY != getHeight() + pos.y()) {
			boundsChanged = true;
			setHeight(lineY - pos.y());
		}
		if (xEnd != pos.x() + getWidth()) {
			boundsChanged = true;
			setWidth(xEnd - pos.x());
		}
		if (boundsChanged) {
			onBoundsUpdate();
		}
	}

	@Override
	public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
		DrawPosition pos = getPos();
		int lineY = pos.y() + 2;
		int lineX = pos.x() + 1;

		int xEnd = lineX + 50;
		if (showCCount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString("C: 186/15000 (s) D: 10, pC: 000, pU: 00, aB: 20", lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}
		if (showECount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString("E: 695/3001, SD: 12", lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}
		if (showPCount.get()) {
			xEnd = Math.max(xEnd, DrawUtil.drawString("P: 200", lineX, lineY, textColor.get().toInt(), shadow.get()));
			lineY += 10;
		}

		boolean boundsChanged = false;
		if (lineY != getHeight() + pos.y()) {
			boundsChanged = true;
			setHeight(lineY - pos.y());
		}
		if (xEnd != pos.x() + getWidth()) {
			boundsChanged = true;
			setWidth(xEnd - pos.x());
		}
		if (boundsChanged) {
			onBoundsUpdate();
		}
	}

	@Override
	public C_0561170 getId() {
		return ID;
	}

	@Override
	public AnchorPoint getAnchor() {
		return anchor.get();
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> options = super.getConfigurationOptions();
		options.add(hide);
		options.add(anchor);
		options.add(showCCount);
		options.add(showECount);
		options.add(showPCount);
		return options;
	}
}
