/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2899740;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;
import net.minecraft.unmapped.C_9590849;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.ItemUtil;

public class HotbarHUD extends TextHudEntry {

	public static final C_0561170 ID = new C_0561170("axolotlclient", "hotbarhud");
	private static final C_0561170 WIDGETS_TEXTURE = new C_0561170("textures/gui/widgets.png");

	private final C_8105098 client = (C_8105098) super.client;

	public HotbarHUD() {
		super(182, 22, false);
		supportsScaling = false;
	}

	@Override
	public void render(AxoRenderContext context, float delta) {
		if (this.client.m_5661944() instanceof C_9590849) {
			super.render(context, delta);
		}
	}

	@Override
	public void renderComponent(AxoRenderContext context, float delta) {
		C_9590849 playerEntity = (C_9590849) this.client.m_5661944();
		if (playerEntity == null || playerEntity.f_3923819 == null || playerEntity.f_3923819.f_8201291 == null) {
			return;
		}
		DrawPosition pos = getPos();
		C_3754158.m_3323122(1.0F, 1.0F, 1.0F, 1.0F);
		C_3754158.m_9671730();
		this.client.m_1218956().m_5325521(WIDGETS_TEXTURE);

		context.br$pushMatrix();
		context.br$translateMatrix(0, 0, -90);
		DrawUtil.m_5935491(pos.x, pos.y, 0, 0, 182, 22, 256, 256);
		DrawUtil.m_5935491(pos.x - 1 + playerEntity.f_3923819.f_4570187 * 20, pos.y - 1, 0, 22, 24, 22, 256, 256);
		context.br$pushMatrix();
		C_3754158.m_6183854();
		C_3754158.m_0833259(770, 771, 1, 0);
		C_2899740.m_1560027();

		for (int j = 0; j < 9; ++j) {
			int k = pos.x + j * 20 + 3;
			int l = pos.y + 3;
			if (playerEntity.f_3923819.f_8201291[j] != null) {
				ItemUtil.renderGuiItemModel(playerEntity.f_3923819.f_8201291[j], k, l);
				ItemUtil.renderGuiItemOverlay(C_8105098.m_0408063().f_0426313,
					playerEntity.f_3923819.f_8201291[j], k, l, null, textColor.get().toInt(), shadow.get());
			}
		}

		C_2899740.m_8989115();
		C_3754158.m_6240595();
		C_3754158.m_5313301();
		context.br$popMatrix();
		context.br$popMatrix();
	}

	@Override
	public void renderPlaceholderComponent(AxoRenderContext context, float delta) {
		DrawPosition pos = getPos();
		DrawUtil.drawCenteredString(C_8105098.m_0408063().f_0426313, getName(), pos.x + width / 2,
			pos.y + height / 2 - 4, -1, true);
	}

	@Override
	public C_0561170 getId() {
		return ID;
	}

	@Override
	public boolean overridesF3() {
		return true;
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> list = new ArrayList<>();
		list.add(enabled);
		list.add(hide);
		list.add(shadow);
		return list;
	}
}
