/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;

public class AddSpecialKeystrokeScreen extends io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen {
	private static final String TITLE = C_3390001.m_2053009("keystrokes.stroke.add.special");
	private final C_3020744 lastScreen;
	public final KeystrokeHud hud;

	public AddSpecialKeystrokeScreen(C_3020744 lastScreen, KeystrokeHud hud) {
		super(TITLE);
		this.lastScreen = lastScreen;
		this.hud = hud;
	}

	@Override
	public void m_3593494() {
		addDrawableChild(new SpecialKeystrokeSelectionList(this, this.f_7153641));

		addDrawableChild(new VanillaButtonWidget(f_5465691 / 2 - 75, f_3080061 - 33 / 2 - 10, 150, 20, C_3390001.m_2053009("gui.done"), button -> f_7153641.m_6408915(lastScreen)));
	}

	@Override
	public void m_7261014(int mouseX, int mouseY, float delta) {
		super.m_7261014(mouseX, mouseY, delta);
		m_2717572(f_2020658, getTitle(), f_5465691 / 2, 33 / 2 - f_2020658.f_6725889 / 2, -1);
	}
}
