/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

import com.google.common.collect.ImmutableList;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ButtonWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.ElementListWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.unmapped.C_1331819;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_7778778;
import net.minecraft.unmapped.C_8105098;
import org.apache.commons.lang3.ArrayUtils;

@Environment(EnvType.CLIENT)
public class KeyBindSelectionList extends ElementListWidget<KeyBindSelectionList.Entry> {
	private static final int ITEM_HEIGHT = 20;
	final KeyBindSelectionScreen keyBindsScreen;
	private final Consumer<C_7778778> selectionConsumer;

	public KeyBindSelectionList(KeyBindSelectionScreen keyBindsScreen, C_8105098 minecraft, Consumer<C_7778778> selectionConsumer) {
		super(minecraft, keyBindsScreen.f_5465691, keyBindsScreen.f_3080061, 33, keyBindsScreen.f_3080061 - 33, ITEM_HEIGHT);
		this.keyBindsScreen = keyBindsScreen;
		this.selectionConsumer = selectionConsumer;
		C_7778778[] keyMappings = ArrayUtils.clone(minecraft.f_9967940.f_8284887);
		Arrays.sort(keyMappings);
		String string = null;

		for (C_7778778 keyMapping : keyMappings) {
			String string2 = keyMapping.m_0586632();
			if (!string2.equals(string)) {
				string = string2;
				this.addEntry(new CategoryEntry(C_3390001.m_2053009(string2)));
			}

			String component = C_3390001.m_2053009(keyMapping.m_4400998());
			this.addEntry(new KeyEntry(keyMapping, component));
		}
	}

	@Override
	public int getRowWidth() {
		return 340;
	}

	@Override
	protected int getScrollbarPositionX() {
		return getRowLeft() + getRowWidth() + 10;
	}

	@Environment(EnvType.CLIENT)
	public class CategoryEntry extends io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindSelectionList.Entry {
		final String name;
		private final int width;

		public CategoryEntry(final String name) {
			this.name = name;
			this.width = KeyBindSelectionList.this.client.f_0426313.m_0040387(this.name);
		}

		@Override
		public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
			KeyBindSelectionList.this.client.f_0426313.m_1950885(this.name, KeyBindSelectionList.this.width / 2f - this.width / 2f, top + height - 9 - 1, -1);
		}

		@Override
		public List<? extends Element> children() {
			return Collections.emptyList();
		}
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry extends ElementListWidget.Entry<io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindSelectionList.Entry> {

	}

	@Environment(EnvType.CLIENT)
	public class KeyEntry extends io.github.axolotlclient.modules.hud.gui.keystrokes.KeyBindSelectionList.Entry {
		private final String name, boundKey;
		private final ButtonWidget changeButton;

		KeyEntry(final C_7778778 key, final String name) {
			this.name = name;
			this.boundKey = C_1331819.m_9293214(key.m_6463487());
			this.changeButton = new VanillaButtonWidget(0, 0, 75, 20, C_3390001.m_2053009("keystrokes.key.select"), button -> {
				selectionConsumer.accept(key);
				keyBindsScreen.closeScreen();
			});
			changeButton.active = !(keyBindsScreen.stroke.getKey() != null && key == keyBindsScreen.stroke.getKey());
		}

		@Override
		public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = KeyBindSelectionList.this.getScrollbarPositionX() - 10;
			int j = top - 2;
			int k = i - 5 - this.changeButton.getWidth();
			this.changeButton.setPosition(k, j);
			this.changeButton.render(mouseX, mouseY, partialTick);
			client.f_0426313.m_1950885(this.name, left, top + height / 2f - 9 / 2f, -1);
			client.f_0426313.m_1950885(boundKey, left + width / 2f - client.f_0426313.m_0040387(boundKey) / 2f, top + height / 2f - 9 / 2f, Colors.GRAY.toInt());
		}

		@Override
		public List<? extends Element> children() {
			return ImmutableList.of(this.changeButton);
		}
	}
}
